/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.lang.reflect.Array;
import java.util.Properties;
import kaffe.io.StdErrorStream;
import kaffe.io.StdInputStream;
import kaffe.io.StdOutputStream;

/*
 * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class System {
    public static final InputStream in;
    public static final PrintStream out;
    public static final PrintStream err;
    private static Properties props;
    private static SecurityManager security;

    private System() {
    }

    public static void arraycopy(Object object, int n, Object object2, int n2, int n3) {
        Class clazz = object.getClass();
        Class clazz2 = clazz.getComponentType();
        Class clazz3 = object2.getClass();
        Class clazz4 = clazz3.getComponentType();
        if (!clazz.isArray() || !clazz3.isArray() || clazz2.isPrimitive() && !clazz4.isPrimitive() || !clazz2.isPrimitive() && clazz4.isPrimitive() || clazz2.isPrimitive() && clazz4.isPrimitive() && clazz2 != clazz4) {
            throw new ArrayStoreException(new StringBuffer().append("not assignable: source type is ").append(clazz.getName()).append(", destination type is ").append(clazz3.getName()).toString());
        }
        if (n3 < 0) {
            throw new ArrayIndexOutOfBoundsException();
        }
        if (object == object2 && n < n2) {
            Object object3 = Array.newInstance(clazz4, n3);
            System.arraycopy(object, n, object3, 0, n3);
            System.arraycopy(object3, 0, object2, n2, n3);
            return;
        }
        if (object2 instanceof Object[]) {
            Object[] objectArray = (Object[])object2;
            Object[] objectArray2 = (Object[])object;
            int n4 = n3 - 1;
            while (n4 >= 0) {
                objectArray[n2++] = objectArray2[n++];
                --n4;
            }
            return;
        }
        if (object2 instanceof int[]) {
            int[] nArray = (int[])object2;
            int[] nArray2 = (int[])object;
            int n5 = n3 - 1;
            while (n5 >= 0) {
                nArray[n2++] = nArray2[n++];
                --n5;
            }
            return;
        }
        if (object2 instanceof float[]) {
            float[] fArray = (float[])object2;
            float[] fArray2 = (float[])object;
            int n6 = n3 - 1;
            while (n6 >= 0) {
                fArray[n2++] = fArray2[n++];
                --n6;
            }
            return;
        }
        if (object2 instanceof long[]) {
            long[] lArray = (long[])object2;
            long[] lArray2 = (long[])object;
            int n7 = n3 - 1;
            while (n7 >= 0) {
                lArray[n2++] = lArray2[n++];
                --n7;
            }
            return;
        }
        if (object2 instanceof double[]) {
            double[] dArray = (double[])object2;
            double[] dArray2 = (double[])object;
            int n8 = n3 - 1;
            while (n8 >= 0) {
                dArray[n2++] = dArray2[n++];
                --n8;
            }
            return;
        }
        if (object2 instanceof boolean[]) {
            boolean[] blArray = (boolean[])object2;
            boolean[] blArray2 = (boolean[])object;
            int n9 = n3 - 1;
            while (n9 >= 0) {
                blArray[n2++] = blArray2[n++];
                --n9;
            }
            return;
        }
        if (object2 instanceof byte[]) {
            byte[] byArray = (byte[])object2;
            byte[] byArray2 = (byte[])object;
            int n10 = n3 - 1;
            while (n10 >= 0) {
                byArray[n2++] = byArray2[n++];
                --n10;
            }
            return;
        }
        if (object2 instanceof char[]) {
            char[] cArray = (char[])object2;
            char[] cArray2 = (char[])object;
            int n11 = n3 - 1;
            while (n11 >= 0) {
                cArray[n2++] = cArray2[n++];
                --n11;
            }
            return;
        }
        if (object2 instanceof short[]) {
            short[] sArray = (short[])object2;
            short[] sArray2 = (short[])object;
            int n12 = n3 - 1;
            while (n12 >= 0) {
                sArray[n2++] = sArray2[n++];
                --n12;
            }
        }
    }

    private static void checkPropertyAccess() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPropertiesAccess();
        }
    }

    public static native long currentTimeMillis();

    public static void exit(int n) {
        Runtime.getRuntime().exit(n);
    }

    public static void gc() {
        Runtime.getRuntime().gc();
    }

    public static Properties getProperties() {
        System.checkPropertyAccess();
        return props;
    }

    public static String getProperty(String string) {
        System.checkPropertyAccess();
        return props.getProperty(string);
    }

    public static String getProperty(String string, String string2) {
        System.checkPropertyAccess();
        return props.getProperty(string, string2);
    }

    public static SecurityManager getSecurityManager() {
        return security;
    }

    public static String getenv(String string) {
        throw new Error("System.getenv no longer supported");
    }

    public static native int identityHashCode(Object var0);

    private static native Properties initProperties(Properties var0);

    public static void load(String string) {
        Runtime.getRuntime().load(string, Class.CallStack.getCallersClassLoader());
    }

    public static void loadLibrary(String string) {
        Runtime.getRuntime().loadLibrary(string, Class.CallStack.getCallersClassLoader());
    }

    public static String mapLibraryName(String string) {
        return new StringBuffer().append(NativeLibrary.getLibPrefix()).append(string).append(NativeLibrary.getLibSuffix()).toString();
    }

    public static void runFinalization() {
        Runtime.getRuntime().runFinalization();
    }

    public static void runFinalizersOnExit(boolean bl) {
        Runtime.getRuntime();
        Runtime.runFinalizersOnExit(bl);
    }

    public static void setErr(PrintStream printStream) {
        System.setErr0(printStream);
    }

    private static native void setErr0(PrintStream var0);

    public static void setIn(InputStream inputStream) {
        System.setIn0(inputStream);
    }

    private static native void setIn0(InputStream var0);

    public static void setOut(PrintStream printStream) {
        System.setOut0(printStream);
    }

    private static native void setOut0(PrintStream var0);

    public static String setProperty(String string, String string2) {
        System.checkPropertyAccess();
        return (String)props.setProperty(string, string2);
    }

    public static void setProperties(Properties properties) {
        System.checkPropertyAccess();
        if (properties == null) {
            props.clear();
            return;
        }
        props = properties;
    }

    public static void setSecurityManager(SecurityManager securityManager) {
        if (security != null) {
            security.checkPermission(new RuntimePermission("setSecurityManager"));
        }
        security = securityManager;
    }

    static {
        props = System.initProperties(new Properties());
        InputStream inputStream = ClassLoader.getSystemResourceAsStream("system.properties");
        if (inputStream != null) {
            try {
                try {
                    props.load(inputStream);
                }
                catch (IOException iOException) {
                }
                Object var2_4 = null;
            }
            catch (Throwable throwable) {
                Object var2_5 = null;
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                throw throwable;
            }
            try {
                inputStream.close();
            }
            catch (IOException iOException) {}
        }
        if (props.getProperty("kaffe.embedded", "false").equals("false")) {
            in = new BufferedInputStream(new FileInputStream(FileDescriptor.in), 128);
            out = new PrintStream(new BufferedOutputStream(new FileOutputStream(FileDescriptor.out), 128), true);
            err = new PrintStream(new BufferedOutputStream(new FileOutputStream(FileDescriptor.err), 128), true);
        } else {
            in = new BufferedInputStream(new StdInputStream(), 128);
            out = new PrintStream(new BufferedOutputStream(new StdOutputStream(), 128), true);
            err = new PrintStream(new BufferedOutputStream(new StdErrorStream(), 128), true);
        }
        try {
            Class.forName("kaffe.lang.SystemClassLoader");
        }
        catch (ClassNotFoundException classNotFoundException) {}
    }
}

