/*
 * Decompiled with CFR 0.152.
 */
package java.lang.reflect;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;

/*
 * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Constructor
extends AccessibleObject
implements Member {
    private Class clazz;
    private int slot;
    private Class[] parameterTypes;
    private Class[] exceptionTypes;

    private Constructor() {
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Constructor)) {
            return false;
        }
        Constructor constructor = (Constructor)object;
        if (this.clazz != constructor.clazz) {
            return false;
        }
        if (this.parameterTypes.length != constructor.parameterTypes.length) {
            return false;
        }
        int n = this.parameterTypes.length;
        while (n-- > 0) {
            if (this.parameterTypes[n] == constructor.parameterTypes[n]) continue;
            return false;
        }
        return true;
    }

    @Override
    public Class getDeclaringClass() {
        return this.clazz;
    }

    public Class[] getExceptionTypes() {
        return this.exceptionTypes;
    }

    @Override
    public native int getModifiers();

    @Override
    public String getName() {
        return this.clazz.getName();
    }

    public Class[] getParameterTypes() {
        return this.parameterTypes;
    }

    public int hashCode() {
        return this.clazz.getName().hashCode();
    }

    public Object newInstance(Object[] objectArray) throws InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        Method method = new Method(this.clazz, this.slot, "<init>", this.clazz, this.parameterTypes, this.exceptionTypes);
        return method.invoke(null, objectArray);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        int n = this.getModifiers();
        if (n != 0) {
            stringBuffer.append(Modifier.toString(n));
            stringBuffer.append(' ');
        }
        stringBuffer.append(this.clazz.getName());
        stringBuffer.append('(');
        int n2 = 0;
        while (n2 < this.parameterTypes.length) {
            stringBuffer.append(Method.getPrettyName(this.parameterTypes[n2]));
            if (n2 + 1 < this.parameterTypes.length) {
                stringBuffer.append(',');
            }
            ++n2;
        }
        stringBuffer.append(')');
        if (this.exceptionTypes.length > 0) {
            stringBuffer.append(" throws ");
            n2 = 0;
            while (n2 < this.exceptionTypes.length) {
                stringBuffer.append(this.exceptionTypes[n2].getName());
                if (n2 + 1 < this.exceptionTypes.length) {
                    stringBuffer.append(',');
                }
                ++n2;
            }
        }
        return stringBuffer.toString();
    }
}

