/*
 * Decompiled with CFR 0.152.
 */
package java.lang.reflect;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Modifier;

/*
 * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Method
extends AccessibleObject
implements Member {
    private static final Object[] nullArgs = new Object[0];
    private Class clazz;
    private int slot;
    private String name;
    private Class returnType;
    private Class[] parameterTypes;
    private Class[] exceptionTypes;

    private static native void init0();

    private Method() {
    }

    Method(Class clazz, int n, String string, Class clazz2, Class[] classArray, Class[] classArray2) {
        this.clazz = clazz;
        this.slot = n;
        this.name = string;
        this.returnType = clazz2;
        this.parameterTypes = classArray;
        this.exceptionTypes = classArray2;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Method)) {
            return false;
        }
        Method method = (Method)object;
        if (this.clazz != method.clazz || this.returnType != method.returnType || this.parameterTypes.length != method.parameterTypes.length || !this.name.equals(method.name)) {
            return false;
        }
        int n = this.parameterTypes.length;
        while (n-- > 0) {
            if (this.parameterTypes[n] == method.parameterTypes[n]) continue;
            return false;
        }
        return true;
    }

    @Override
    public Class getDeclaringClass() {
        return this.clazz;
    }

    public Class[] getExceptionTypes() {
        return this.exceptionTypes;
    }

    @Override
    public native int getModifiers();

    @Override
    public String getName() {
        return this.name;
    }

    public Class[] getParameterTypes() {
        return this.parameterTypes;
    }

    public Class getReturnType() {
        return this.returnType;
    }

    public int hashCode() {
        return this.clazz.getName().hashCode() ^ this.name.hashCode();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Object invoke(Object object, Object[] objectArray) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        if (objectArray == null) {
            objectArray = nullArgs;
        }
        if (object == null && !"<init>".equals(this.name) && !Modifier.isStatic(this.getModifiers())) {
            throw new NullPointerException("Null object pointer");
        }
        if (object != null && !this.getDeclaringClass().isInstance(object)) {
            throw new IllegalArgumentException("Object type doesn't match method's class");
        }
        if (objectArray.length != this.getParameterTypes().length) {
            throw new IllegalArgumentException("wrong number of arguments");
        }
        int n = 0;
        while (n < objectArray.length) {
            Class clazz = this.parameterTypes[n];
            Object object2 = objectArray[n];
            if ((object2 != null || clazz.isPrimitive()) && !clazz.isAssignableFrom(object2.getClass())) {
                if (!clazz.isPrimitive()) throw new IllegalArgumentException("incompatible argument");
                if (clazz == Boolean.TYPE) {
                    if (!(object2 instanceof Boolean)) {
                        throw new IllegalArgumentException();
                    }
                } else if (clazz == Byte.TYPE) {
                    if (!(object2 instanceof Byte)) {
                        throw new IllegalArgumentException();
                    }
                } else if (clazz == Short.TYPE) {
                    if (!(object2 instanceof Short)) {
                        if (!(object2 instanceof Byte)) throw new IllegalArgumentException();
                        objectArray[n] = new Short(((Byte)object2).byteValue());
                    }
                } else if (clazz == Character.TYPE) {
                    if (!(object2 instanceof Character)) {
                        throw new IllegalArgumentException();
                    }
                } else if (clazz == Integer.TYPE) {
                    if (!(object2 instanceof Integer)) {
                        if (object2 instanceof Short) {
                            objectArray[n] = new Integer(((Short)object2).shortValue());
                        } else if (object2 instanceof Character) {
                            objectArray[n] = new Integer(((Character)object2).charValue());
                        } else {
                            if (!(object2 instanceof Byte)) throw new IllegalArgumentException();
                            objectArray[n] = new Integer(((Byte)object2).byteValue());
                        }
                    }
                } else if (clazz == Long.TYPE) {
                    if (!(object2 instanceof Long)) {
                        if (object2 instanceof Integer) {
                            objectArray[n] = new Long(((Integer)object2).intValue());
                        } else if (object2 instanceof Short) {
                            objectArray[n] = new Long(((Short)object2).shortValue());
                        } else if (object2 instanceof Character) {
                            objectArray[n] = new Long(((Character)object2).charValue());
                        } else {
                            if (!(object2 instanceof Byte)) throw new IllegalArgumentException();
                            objectArray[n] = new Long(((Byte)object2).byteValue());
                        }
                    }
                } else if (clazz == Float.TYPE) {
                    if (!(object2 instanceof Float)) {
                        if (object2 instanceof Long) {
                            objectArray[n] = new Float(((Long)object2).longValue());
                        } else if (object2 instanceof Integer) {
                            objectArray[n] = new Float(((Integer)object2).intValue());
                        } else if (object2 instanceof Short) {
                            objectArray[n] = new Float(((Short)object2).shortValue());
                        } else if (object2 instanceof Character) {
                            objectArray[n] = new Float(((Character)object2).charValue());
                        } else {
                            if (!(object2 instanceof Byte)) throw new IllegalArgumentException();
                            objectArray[n] = new Float(((Byte)object2).byteValue());
                        }
                    }
                } else {
                    if (clazz != Double.TYPE) throw new Error("cannot happen");
                    if (!(object2 instanceof Double)) {
                        if (object2 instanceof Float) {
                            objectArray[n] = new Double(((Float)object2).floatValue());
                        } else if (object2 instanceof Long) {
                            objectArray[n] = new Double(((Long)object2).longValue());
                        } else if (object2 instanceof Integer) {
                            objectArray[n] = new Double(((Integer)object2).intValue());
                        } else if (object2 instanceof Short) {
                            objectArray[n] = new Double(((Short)object2).shortValue());
                        } else if (object2 instanceof Character) {
                            objectArray[n] = new Double(((Character)object2).charValue());
                        } else {
                            if (!(object2 instanceof Byte)) throw new IllegalArgumentException();
                            objectArray[n] = new Double(((Byte)object2).byteValue());
                        }
                    }
                }
            }
            ++n;
        }
        return this.invoke0(object, objectArray);
    }

    native Object invoke0(Object var1, Object[] var2) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException;

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        int n = this.getModifiers();
        if (n != 0) {
            stringBuffer.append(Modifier.toString(n));
            stringBuffer.append(' ');
        }
        stringBuffer.append(Method.getPrettyName(this.returnType));
        stringBuffer.append(' ');
        stringBuffer.append(this.clazz.getName());
        stringBuffer.append('.');
        stringBuffer.append(this.name);
        stringBuffer.append('(');
        int n2 = 0;
        while (n2 < this.parameterTypes.length) {
            stringBuffer.append(Method.getPrettyName(this.parameterTypes[n2]));
            if (n2 + 1 < this.parameterTypes.length) {
                stringBuffer.append(',');
            }
            ++n2;
        }
        stringBuffer.append(')');
        if (this.exceptionTypes.length > 0) {
            stringBuffer.append(" throws ");
            n2 = 0;
            while (n2 < this.exceptionTypes.length) {
                stringBuffer.append(this.exceptionTypes[n2].getName());
                if (n2 + 1 < this.exceptionTypes.length) {
                    stringBuffer.append(',');
                }
                ++n2;
            }
        }
        return stringBuffer.toString();
    }

    static String getPrettyName(Class clazz) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (true) {
            if (!clazz.isArray()) {
                stringBuffer.append(clazz.getName());
                while (n > 0) {
                    stringBuffer.append("[]");
                    --n;
                }
                return stringBuffer.toString();
            }
            clazz = clazz.getComponentType();
            ++n;
        }
    }

    static {
        Method.init0();
    }
}

