/*
 * Decompiled with CFR 0.152.
 */
package java.net;

import java.net.InetAddress;
import java.net.NetPermission;
import java.net.PasswordAuthentication;

/*
 * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Authenticator {
    private static Authenticator default_authenticator;
    private String host;
    private InetAddress addr;
    private int port;
    private String protocol;
    private String prompt;
    private String scheme;

    public static void setDefault(Authenticator authenticator) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new NetPermission("setDefaultAuthenticator"));
        }
        default_authenticator = authenticator;
    }

    public static PasswordAuthentication requestPasswordAuthentication(InetAddress inetAddress, int n, String string, String string2, String string3) throws SecurityException {
        return Authenticator.requestPasswordAuthentication(null, inetAddress, n, string, string2, string3);
    }

    public static PasswordAuthentication requestPasswordAuthentication(String string, InetAddress inetAddress, int n, String string2, String string3, String string4) throws SecurityException {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new NetPermission("requestPasswordAuthentication"));
        }
        if (default_authenticator == null) {
            return null;
        }
        Authenticator.default_authenticator.host = string;
        Authenticator.default_authenticator.addr = inetAddress;
        Authenticator.default_authenticator.port = n;
        Authenticator.default_authenticator.protocol = string2;
        Authenticator.default_authenticator.prompt = string3;
        Authenticator.default_authenticator.scheme = string4;
        return default_authenticator.getPasswordAuthentication();
    }

    protected final String getRequestingHost() {
        return this.host;
    }

    protected final InetAddress getRequestingSite() {
        return this.addr;
    }

    protected final int getRequestingPort() {
        return this.port;
    }

    protected final String getRequestingProtocol() {
        return this.protocol;
    }

    protected final String getRequestingPrompt() {
        return this.prompt;
    }

    protected final String getRequestingScheme() {
        return this.scheme;
    }

    protected PasswordAuthentication getPasswordAuthentication() {
        return null;
    }
}

