/*
 * Decompiled with CFR 0.152.
 */
package java.net;

import java.net.InetAddress;
import java.net.UnknownHostException;

/*
 * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DatagramPacket {
    private byte[] buf;
    private int offset;
    private int length;
    private InetAddress address;
    private int port;
    private static final int DEFAULT_RECEIVE_PORT = -1;
    private static final int MAX_PORT = 65535;
    private static final int MIN_LENGTH = 0;
    private static final int MIN_OFFSET = 0;
    private static final int MIN_PORT = 0;

    public DatagramPacket(byte[] byArray, int n) {
        this(byArray, 0, n);
    }

    public DatagramPacket(byte[] byArray, int n, int n2) {
        this.setData(byArray, n, n2);
        this.port = -1;
    }

    public DatagramPacket(byte[] byArray, int n, InetAddress inetAddress, int n2) {
        this(byArray, 0, n, inetAddress, n2);
    }

    public DatagramPacket(byte[] byArray, int n, int n2, InetAddress inetAddress, int n3) {
        this.setData(byArray, n, n2);
        this.setAddress(inetAddress);
        this.setPort(n3);
    }

    public synchronized InetAddress getAddress() {
        return this.address;
    }

    public synchronized byte[] getData() {
        return this.buf;
    }

    private static InetAddress getDefaultAddress() {
        InetAddress inetAddress;
        try {
            inetAddress = InetAddress.getLocalHost();
        }
        catch (UnknownHostException unknownHostException) {
            inetAddress = InetAddress.getLoopback();
        }
        return inetAddress;
    }

    public synchronized int getLength() {
        return this.length;
    }

    public synchronized int getOffset() {
        return this.offset;
    }

    public synchronized int getPort() {
        return this.port;
    }

    synchronized void prime() {
        this.address = new InetAddress();
    }

    public synchronized void setAddress(InetAddress inetAddress) {
        this.address = inetAddress;
    }

    public synchronized void setData(byte[] byArray) {
        this.setData(byArray, 0, byArray.length);
    }

    public synchronized void setData(byte[] byArray, int n, int n2) {
        if (n > byArray.length - n2 || n < 0 || n2 < 0) {
            throw new IllegalArgumentException("illegal length or offset");
        }
        this.buf = byArray;
        this.offset = n;
        this.length = Math.min(n2, this.buf.length);
    }

    public synchronized void setLength(int n) {
        if (this.offset + n > this.buf.length || this.offset + n < this.offset) {
            throw new IllegalArgumentException("illegal length");
        }
        this.length = n;
        this.length = n;
    }

    public synchronized void setPort(int n) {
        if (n < 0 || n > 65535) {
            throw new IllegalArgumentException(new StringBuffer().append("Port out of range:").append(n).toString());
        }
        this.port = n;
    }
}

