/*
 * Decompiled with CFR 0.152.
 */
package java.net;

import java.net.InetAddress;
import java.net.SocketAddress;
import java.net.UnknownHostException;

/*
 * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InetSocketAddress
extends SocketAddress {
    private static final long serialVersionUID = 5076001401234631237L;
    String hostname;
    InetAddress addr;
    int port;

    public InetSocketAddress(InetAddress inetAddress, int n) throws IllegalArgumentException {
        if (n < 0 || n > 65535) {
            throw new IllegalArgumentException();
        }
        this.addr = inetAddress;
        this.port = n;
        this.hostname = inetAddress.getHostName();
    }

    public InetSocketAddress(int n) throws IllegalArgumentException {
        if (n < 0 || n > 65535) {
            throw new IllegalArgumentException();
        }
        this.port = n;
        try {
            byte[] byArray = new byte[]{0, 0, 0, 0};
            this.addr = InetAddress.getByAddress(byArray);
            this.hostname = "0.0.0.0";
            return;
        }
        catch (UnknownHostException unknownHostException) {
            this.addr = null;
            this.hostname = "";
            return;
        }
    }

    public InetSocketAddress(String string, int n) throws IllegalArgumentException {
        if (n < 0 || n > 65535) {
            throw new IllegalArgumentException();
        }
        this.port = n;
        this.hostname = string;
        try {
            this.addr = InetAddress.getByName(string);
            return;
        }
        catch (Exception exception) {
            this.addr = null;
            return;
        }
    }

    public final boolean equals(Object object) {
        if (object instanceof InetSocketAddress) {
            InetSocketAddress inetSocketAddress = (InetSocketAddress)object;
            return this.addr.equals(inetSocketAddress.addr) && inetSocketAddress.port == this.port;
        }
        return false;
    }

    public final InetAddress getAddress() {
        return this.addr;
    }

    public final String getHostName() {
        return this.hostname;
    }

    public final int getPort() {
        return this.port;
    }

    public final int hashCode() {
        return this.port + this.addr.hashCode();
    }

    public final boolean isUnresolved() {
        return this.addr == null;
    }

    public String toString() {
        return new StringBuffer().append(this.addr).append(":").append(this.port).toString();
    }
}

