/*
 * Decompiled with CFR 0.152.
 */
package java.net;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLStreamHandler;
import java.net.URLStreamHandlerFactory;
import java.security.Certificate;
import java.security.CodeSource;
import java.security.PermissionCollection;
import java.security.SecureClassLoader;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Vector;
import java.util.jar.Attributes;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;
import kaffe.lang.PackageHelper;

/*
 * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
 */
public class URLClassLoader
extends SecureClassLoader {
    private final Vector urls;
    private final URLStreamHandlerFactory factory;
    private final Map handlers;
    private final Map jarFiles;

    public URLClassLoader(URL[] uRLArray, ClassLoader classLoader) {
        this(uRLArray, classLoader, null);
    }

    public URLClassLoader(URL[] uRLArray) {
        this(uRLArray, Class.forName("java.net.URLClassLoader").getClassLoader(), null);
    }

    public URLClassLoader(URL[] uRLArray, ClassLoader classLoader, URLStreamHandlerFactory uRLStreamHandlerFactory) {
        super(classLoader);
        this.Block$();
        this.urls = new Vector();
        this.factory = uRLStreamHandlerFactory;
        int n = 0;
        while (n < uRLArray.length) {
            this.addURL(uRLArray[n]);
            ++n;
        }
    }

    protected void addURL(URL uRL) {
        this.urls.addElement(uRL);
    }

    public URL[] getURLs() {
        return (URL[])this.urls.toArray(new URL[this.urls.size()]);
    }

    @Override
    protected Class findClass(String string) throws ClassNotFoundException {
        URL uRL = this.findResource(new StringBuffer().append(string.replace('.', '/')).append(".class").toString());
        if (uRL == null) {
            throw new ClassNotFoundException(string);
        }
        try {
            int n;
            InputStream inputStream = uRL.openStream();
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            byte[] byArray = new byte[1024];
            while ((n = inputStream.read(byArray)) != -1) {
                byteArrayOutputStream.write(byArray, 0, n);
            }
            byArray = byteArrayOutputStream.toByteArray();
            Class clazz = this.defineClass(string, byArray, 0, byArray.length, new CodeSource(uRL, new Certificate[0]));
            String string2 = PackageHelper.getPackageName(clazz);
            if (this.getPackage(string2) == null) {
                if (inputStream instanceof JarInputStream) {
                    this.definePackage(string2, ((JarInputStream)inputStream).getManifest(), uRL);
                } else {
                    this.definePackage(string2, null, null, null, null, null, null, null);
                }
            }
            inputStream.close();
            return clazz;
        }
        catch (IOException iOException) {
            throw new ClassNotFoundException(new StringBuffer().append(string).append(": ").append(iOException).toString());
        }
    }

    private URLStreamHandler getHandler(URL uRL) {
        if (this.factory == null) {
            return null;
        }
        String string = uRL.getProtocol();
        URLStreamHandler uRLStreamHandler = (URLStreamHandler)this.handlers.get(string);
        if (uRLStreamHandler == null) {
            uRLStreamHandler = this.factory.createURLStreamHandler(string);
            this.handlers.put(string, uRLStreamHandler);
        }
        return uRLStreamHandler;
    }

    protected Package definePackage(String string, Manifest manifest, URL uRL) throws IllegalArgumentException {
        return super.definePackage(string, manifest.getAttributes(string).getValue(Attributes.Name.SPECIFICATION_TITLE), manifest.getAttributes(string).getValue(Attributes.Name.SPECIFICATION_VERSION), manifest.getAttributes(string).getValue(Attributes.Name.SPECIFICATION_VENDOR), manifest.getAttributes(string).getValue(Attributes.Name.IMPLEMENTATION_TITLE), manifest.getAttributes(string).getValue(Attributes.Name.IMPLEMENTATION_VERSION), manifest.getAttributes(string).getValue(Attributes.Name.IMPLEMENTATION_VENDOR), null);
    }

    @Override
    public URL findResource(String string) {
        try {
            return (URL)this.findResources(string).nextElement();
        }
        catch (IOException iOException) {
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        return null;
    }

    @Override
    public Enumeration findResources(String string) throws IOException {
        Vector vector = new Vector();
        int n = 0;
        while (n < this.urls.size()) {
            block8: {
                URL uRL = (URL)this.urls.elementAt(n);
                try {
                    Object object;
                    if (uRL.getFile().endsWith("/")) {
                        uRL = new URL(uRL, string, this.getHandler(uRL));
                    } else {
                        object = this.getJar(uRL);
                        if (object == null) break block8;
                        uRL = new URL(new StringBuffer().append("jar:file:").append(object).append("!/").append(string).toString());
                    }
                    object = uRL.openConnection();
                    vector.addElement(uRL);
                    try {
                        object.getClass().getMethod("disconnect", null).invoke(object, new Object[0]);
                    }
                    catch (Exception exception) {}
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            ++n;
        }
        return vector.elements();
    }

    private File getJar(URL uRL) {
        File file = (File)this.jarFiles.get(uRL);
        if (file != null) {
            return file;
        }
        String string = uRL.getProtocol();
        String string2 = uRL.getHost();
        if ((string.equals("file") || string.equals("jar")) && (string2.equals("") || string2.equals("localhost")) && (file = new File(uRL.getFile())).exists() && !file.isDirectory()) {
            this.jarFiles.put(uRL, file);
            return file;
        }
        try {
            int n;
            file = File.createTempFile("jar", null);
            file.deleteOnExit();
            InputStream inputStream = uRL.openStream();
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            byte[] byArray = new byte[1024];
            while ((n = inputStream.read(byArray)) != -1) {
                fileOutputStream.write(byArray, 0, n);
            }
            inputStream.close();
            fileOutputStream.close();
            this.jarFiles.put(uRL, file);
            return file;
        }
        catch (IOException iOException) {
            return null;
        }
    }

    @Override
    protected PermissionCollection getPermissions(CodeSource codeSource) {
        return super.getPermissions(codeSource);
    }

    public static URLClassLoader newInstance(URL[] uRLArray, ClassLoader classLoader) {
        return new URLClassLoader(uRLArray, classLoader);
    }

    public static URLClassLoader newInstance(URL[] uRLArray) {
        return new URLClassLoader(uRLArray);
    }

    private /* synthetic */ void Block$() {
        this.handlers = new Hashtable();
        this.jarFiles = new Hashtable();
    }
}

