/*
 * Decompiled with CFR 0.152.
 */
package java.net;

import java.io.IOException;
import java.net.InetAddress;
import java.net.URL;
import java.net.URLConnection;
import java.net.UnknownHostException;
import java.util.StringTokenizer;

/*
 * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class URLStreamHandler {
    protected abstract URLConnection openConnection(URL var1) throws IOException;

    protected boolean equals(URL uRL, URL uRL2) {
        return this.sameFile(uRL, uRL2) && !(uRL.getRef() == null ? uRL2.getRef() != null : !uRL.getRef().equals(uRL2.getRef()));
    }

    protected int getDefaultPort() {
        return -1;
    }

    protected InetAddress getHostAddress(URL uRL) {
        String string = uRL.getHost();
        if (string == null) {
            return null;
        }
        try {
            return InetAddress.getByName(string);
        }
        catch (UnknownHostException unknownHostException) {
            return null;
        }
    }

    protected void parseURL(URL uRL, String string, int n, int n2) {
        int n3;
        String string2 = string.substring(n, n2);
        boolean bl = false;
        String string3 = uRL.getHost();
        int n4 = uRL.getPort();
        String string4 = uRL.getFile();
        int n5 = 0;
        if (string2.length() > 2 && string2.startsWith("//")) {
            n5 = 2;
            bl = true;
            n3 = string2.indexOf(58, n5);
            int n6 = string2.indexOf(47, n5);
            if (n3 != -1 && (n6 == -1 || n3 < n6)) {
                string3 = string2.substring(n5, n3);
                String string5 = string2.substring(n3 + 1, n6 != -1 ? n6 : string2.length());
                try {
                    n4 = Integer.parseInt(string5);
                }
                catch (NumberFormatException numberFormatException) {
                    n4 = uRL.getPort();
                }
            } else {
                string3 = n6 != -1 ? string2.substring(n5, n6) : string2.substring(n5);
            }
            n5 = n6;
        } else if (string2.length() == 0) {
            n5 = -1;
        }
        if (n5 != -1) {
            string4 = string4.equals("") || string2.charAt(n5) == '/' ? string2.substring(n5) : ((n3 = string4.lastIndexOf(47)) == -1 ? string2.substring(n5) : new StringBuffer().append(string4.substring(0, n3 + 1)).append(string2.substring(n5)).toString());
        } else if (bl) {
            string4 = "/";
        }
        this.setURL(uRL, uRL.getProtocol(), string3, n4, this.compressFile(string4), uRL.getRef());
    }

    protected boolean sameFile(URL uRL, URL uRL2) {
        return uRL.getProtocol().equals(uRL2.getProtocol()) && uRL.getHost().equals(uRL2.getHost()) && (uRL.getPort() == uRL2.getPort() || uRL.getPort() == -1 && uRL2.getPort() == this.getDefaultPort() || uRL.getPort() == this.getDefaultPort() && uRL2.getPort() == -1) && uRL.getFile().equals(uRL2.getFile());
    }

    protected void setURL(URL uRL, String string, String string2, int n, String string3, String string4) {
        uRL.set(string, string2, n, string3, string4);
    }

    protected String toExternalForm(URL uRL) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(uRL.getProtocol());
        stringBuffer.append(":");
        String string = uRL.getHost();
        if (string != null && !uRL.getHost().equals("")) {
            stringBuffer.append("//");
            stringBuffer.append(uRL.getHost());
            if (uRL.getPort() != -1) {
                stringBuffer.append(":");
                stringBuffer.append(Integer.toString(uRL.getPort()));
            }
        }
        stringBuffer.append(uRL.getFile());
        if (uRL.getRef() != null && !uRL.getRef().equals("")) {
            stringBuffer.append('#');
            stringBuffer.append(uRL.getRef());
        }
        return stringBuffer.toString();
    }

    private String compressFile(String string) {
        boolean bl = string.length() > 0 && string.charAt(0) == '/';
        StringTokenizer stringTokenizer = new StringTokenizer(string, "/");
        int n = stringTokenizer.countTokens();
        String[] stringArray = new String[n + 2];
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            String string2 = stringTokenizer.nextToken();
            if (string2.equals("..")) {
                --n2;
            } else if (!string2.equals(".")) {
                if (n3 + 1 < n || string.endsWith("/")) {
                    string2 = new StringBuffer().append(string2).append('/').toString();
                }
                stringArray[n2] = string2;
                ++n2;
            }
            ++n3;
        }
        StringBuffer stringBuffer = new StringBuffer();
        if (bl) {
            stringBuffer.append('/');
        }
        int n4 = 0;
        while (n4 < n2) {
            stringBuffer.append(stringArray[n4]);
            ++n4;
        }
        return stringBuffer.toString();
    }
}

