/*
 * Decompiled with CFR 0.152.
 */
package java.nio;

import java.nio.InvalidMarkException;

/*
 * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Buffer {
    protected int cap;
    int limit;
    int pos;
    int mark;

    public final int capacity() {
        return this.cap;
    }

    public final Buffer clear() {
        this.limit = this.cap;
        this.pos = 0;
        this.mark = -1;
        return this;
    }

    public final Buffer flip() {
        this.limit = this.pos;
        this.pos = 0;
        this.mark = -1;
        return this;
    }

    public final boolean hasRemaining() {
        return this.limit > this.pos;
    }

    public abstract boolean isReadOnly();

    public final int limit() {
        return this.limit;
    }

    public final Buffer limit(int n) {
        if (n < 0 || n > this.cap) {
            throw new IllegalArgumentException();
        }
        if (n <= this.mark) {
            this.mark = -1;
        }
        if (this.pos > n) {
            this.pos = n - 1;
        }
        this.limit = n;
        return this;
    }

    public final Buffer mark() {
        this.mark = this.pos;
        return this;
    }

    public final int position() {
        return this.pos;
    }

    public final Buffer position(int n) {
        if (n < 0 || n > this.limit) {
            throw new IllegalArgumentException();
        }
        if (n <= this.mark) {
            this.mark = -1;
        }
        this.pos = n;
        return this;
    }

    public final int remaining() {
        return this.limit - this.pos;
    }

    public final Buffer reset() {
        if (this.mark == -1) {
            throw new InvalidMarkException();
        }
        this.pos = this.mark;
        return this;
    }

    public final Buffer rewind() {
        this.pos = 0;
        this.mark = -1;
        return this;
    }

    public Buffer() {
        this.Block$();
    }

    private /* synthetic */ void Block$() {
        this.cap = 0;
        this.limit = 0;
        this.pos = 0;
        this.mark = -1;
    }
}

