/*
 * Decompiled with CFR 0.152.
 */
package java.nio;

import gnu.java.nio.CharBufferImpl;
import java.nio.Buffer;
import java.nio.ByteOrder;
import java.nio.ReadOnlyBufferException;

/*
 * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CharBuffer
extends Buffer
implements Comparable,
CharSequence {
    private ByteOrder endian;
    protected char[] backing_buffer;
    protected int array_offset;

    public static CharBuffer allocate(int n) {
        return new CharBufferImpl(n, 0, n);
    }

    public static final CharBuffer wrap(char[] cArray, int n, int n2) {
        return new CharBufferImpl(cArray, n, n + n2);
    }

    public static final CharBuffer wrap(char[] cArray) {
        return CharBuffer.wrap(cArray, 0, cArray.length);
    }

    public static final CharBuffer wrap(CharSequence charSequence, int n, int n2) {
        return CharBuffer.wrap(charSequence.toString().toCharArray(), 0, n2);
    }

    public static final CharBuffer wrap(CharSequence charSequence) {
        return CharBuffer.wrap(charSequence, 0, charSequence.length());
    }

    public CharBuffer get(char[] cArray, int n, int n2) {
        if (n < 0 || n > cArray.length || n2 < 0 || n2 > cArray.length - n) {
            throw new IndexOutOfBoundsException();
        }
        int n3 = n;
        while (n3 < n + n2) {
            cArray[n3] = this.get();
            ++n3;
        }
        return this;
    }

    public CharBuffer get(char[] cArray) {
        return this.get(cArray, 0, cArray.length);
    }

    /*
     * Unable to fully structure code
     */
    public CharBuffer put(CharBuffer var1_1) {
        if (var1_1 != this) ** GOTO lbl5
        throw new IllegalArgumentException();
lbl-1000:
        // 1 sources

        {
            this.put(var1_1.get());
lbl5:
            // 2 sources

            ** while (var1_1.hasRemaining())
        }
lbl6:
        // 1 sources

        return this;
    }

    public CharBuffer put(char[] cArray, int n, int n2) {
        if (n < 0 || n > cArray.length || n2 < 0 || n2 > cArray.length - n) {
            throw new IndexOutOfBoundsException();
        }
        int n3 = n;
        while (n3 < n + n2) {
            this.put(cArray[n3]);
            ++n3;
        }
        return this;
    }

    public CharBuffer put(String string, int n, int n2) {
        return this.put(string.toCharArray(), n, n2);
    }

    public final CharBuffer put(String string) {
        return this.put(string, 0, string.length());
    }

    public final CharBuffer put(char[] cArray) {
        return this.put(cArray, 0, cArray.length);
    }

    public final boolean hasArray() {
        return this.backing_buffer != null;
    }

    public final char[] array() {
        if (!this.hasArray()) {
            throw new UnsupportedOperationException();
        }
        if (this.isReadOnly()) {
            throw new ReadOnlyBufferException();
        }
        return this.backing_buffer;
    }

    public final int arrayOffset() {
        if (!this.hasArray()) {
            throw new UnsupportedOperationException();
        }
        if (this.isReadOnly()) {
            throw new ReadOnlyBufferException();
        }
        return this.array_offset;
    }

    public int hashCode() {
        return super.hashCode();
    }

    public boolean equals(Object object) {
        if (object instanceof CharBuffer) {
            return this.compareTo(object) == 0;
        }
        return false;
    }

    @Override
    public abstract CharSequence subSequence(int var1, int var2);

    @Override
    public final int length() {
        return this.remaining();
    }

    @Override
    public final char charAt(int n) {
        if (n < 0 || n >= this.length()) {
            throw new IndexOutOfBoundsException();
        }
        return this.get(this.position() + n);
    }

    @Override
    public String toString() {
        if (this.hasArray()) {
            return new String(this.array(), this.position(), this.length());
        }
        StringBuffer stringBuffer = new StringBuffer(this.length());
        int n = this.position();
        while (n < this.limit()) {
            stringBuffer.append(this.get(n));
            ++n;
        }
        return stringBuffer.toString();
    }

    @Override
    public int compareTo(Object object) {
        CharBuffer charBuffer = (CharBuffer)object;
        if (charBuffer.remaining() != this.remaining()) {
            return 1;
        }
        if (!this.hasArray() || !charBuffer.hasArray()) {
            return 1;
        }
        int n = this.remaining();
        int n2 = this.position();
        int n3 = charBuffer.position();
        int n4 = 0;
        while (n4 < n) {
            int n5 = this.get(n2) - charBuffer.get(n3);
            if (n5 != 0) {
                return n5;
            }
            ++n4;
        }
        return 0;
    }

    public abstract ByteOrder order();

    public abstract char get();

    public abstract CharBuffer put(char var1);

    public abstract char get(int var1);

    public abstract CharBuffer put(int var1, char var2);

    public abstract CharBuffer compact();

    public abstract boolean isDirect();

    public abstract CharBuffer slice();

    public abstract CharBuffer duplicate();

    public abstract CharBuffer asReadOnlyBuffer();

    public CharBuffer() {
        this.Block$();
    }

    private /* synthetic */ void Block$() {
        this.endian = ByteOrder.BIG_ENDIAN;
    }
}

