/*
 * Decompiled with CFR 0.152.
 */
package java.nio;

import gnu.java.nio.DoubleBufferImpl;
import java.nio.Buffer;
import java.nio.ByteOrder;

/*
 * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DoubleBuffer
extends Buffer
implements Comparable {
    private ByteOrder endian;
    protected double[] backing_buffer;

    public static DoubleBuffer allocateDirect(int n) {
        return new DoubleBufferImpl(n, 0, n);
    }

    public static DoubleBuffer allocate(int n) {
        return new DoubleBufferImpl(n, 0, n);
    }

    public static final DoubleBuffer wrap(double[] dArray, int n, int n2) {
        return new DoubleBufferImpl(dArray, n, n2);
    }

    public static final DoubleBuffer wrap(String string) {
        int n = string.length();
        double[] dArray = new double[n];
        int n2 = 0;
        while (n2 < n) {
            dArray[n2] = string.charAt(n2);
            ++n2;
        }
        return DoubleBuffer.wrap(dArray, 0, n);
    }

    public static final DoubleBuffer wrap(double[] dArray) {
        return DoubleBuffer.wrap(dArray, 0, dArray.length);
    }

    public DoubleBuffer get(double[] dArray, int n, int n2) {
        int n3 = n;
        while (n3 < n + n2) {
            dArray[n3] = this.get();
            ++n3;
        }
        return this;
    }

    public DoubleBuffer get(double[] dArray) {
        return this.get(dArray, 0, dArray.length);
    }

    public DoubleBuffer put(DoubleBuffer doubleBuffer) {
        while (doubleBuffer.hasRemaining()) {
            this.put(doubleBuffer.get());
        }
        return this;
    }

    public DoubleBuffer put(double[] dArray, int n, int n2) {
        int n3 = n;
        while (n3 < n + n2) {
            this.put(dArray[n3]);
            ++n3;
        }
        return this;
    }

    public final DoubleBuffer put(double[] dArray) {
        return this.put(dArray, 0, dArray.length);
    }

    public final boolean hasArray() {
        return this.backing_buffer != null;
    }

    public final double[] array() {
        return this.backing_buffer;
    }

    public final int arrayOffset() {
        return 0;
    }

    public int hashCode() {
        return super.hashCode();
    }

    public boolean equals(Object object) {
        if (object instanceof DoubleBuffer) {
            return this.compareTo(object) == 0;
        }
        return false;
    }

    @Override
    public int compareTo(Object object) {
        DoubleBuffer doubleBuffer = (DoubleBuffer)object;
        if (doubleBuffer.remaining() != this.remaining()) {
            return 1;
        }
        if (!this.hasArray() || !doubleBuffer.hasArray()) {
            return 1;
        }
        int n = this.remaining();
        int n2 = this.position();
        int n3 = doubleBuffer.position();
        int n4 = 0;
        while (n4 < n) {
            int n5 = (int)(this.get(n2) - doubleBuffer.get(n3));
            if (n5 != 0) {
                return n5;
            }
            ++n4;
        }
        return 0;
    }

    public ByteOrder order() {
        return this.endian;
    }

    public final DoubleBuffer order(ByteOrder byteOrder) {
        this.endian = byteOrder;
        return this;
    }

    public abstract double get();

    public abstract DoubleBuffer put(double var1);

    public abstract double get(int var1);

    public abstract DoubleBuffer put(int var1, double var2);

    public abstract DoubleBuffer compact();

    public abstract boolean isDirect();

    public abstract DoubleBuffer slice();

    public abstract DoubleBuffer duplicate();

    public abstract DoubleBuffer asReadOnlyBuffer();

    public DoubleBuffer() {
        this.Block$();
    }

    private /* synthetic */ void Block$() {
        this.endian = ByteOrder.BIG_ENDIAN;
    }
}

