/*
 * Decompiled with CFR 0.152.
 */
package java.nio;

import gnu.java.nio.FloatBufferImpl;
import java.nio.Buffer;
import java.nio.ByteOrder;

/*
 * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class FloatBuffer
extends Buffer
implements Comparable {
    private ByteOrder endian;
    protected float[] backing_buffer;

    public static FloatBuffer allocateDirect(int n) {
        return new FloatBufferImpl(n, 0, n);
    }

    public static FloatBuffer allocate(int n) {
        return new FloatBufferImpl(n, 0, n);
    }

    public static final FloatBuffer wrap(float[] fArray, int n, int n2) {
        return new FloatBufferImpl(fArray, n, n2);
    }

    public static final FloatBuffer wrap(String string) {
        int n = string.length();
        float[] fArray = new float[n];
        int n2 = 0;
        while (n2 < n) {
            fArray[n2] = string.charAt(n2);
            ++n2;
        }
        return FloatBuffer.wrap(fArray, 0, n);
    }

    public static final FloatBuffer wrap(float[] fArray) {
        return FloatBuffer.wrap(fArray, 0, fArray.length);
    }

    public FloatBuffer get(float[] fArray, int n, int n2) {
        int n3 = n;
        while (n3 < n + n2) {
            fArray[n3] = this.get();
            ++n3;
        }
        return this;
    }

    public FloatBuffer get(float[] fArray) {
        return this.get(fArray, 0, fArray.length);
    }

    public FloatBuffer put(FloatBuffer floatBuffer) {
        while (floatBuffer.hasRemaining()) {
            this.put(floatBuffer.get());
        }
        return this;
    }

    public FloatBuffer put(float[] fArray, int n, int n2) {
        int n3 = n;
        while (n3 < n + n2) {
            this.put(fArray[n3]);
            ++n3;
        }
        return this;
    }

    public final FloatBuffer put(float[] fArray) {
        return this.put(fArray, 0, fArray.length);
    }

    public final boolean hasArray() {
        return this.backing_buffer != null;
    }

    public final float[] array() {
        return this.backing_buffer;
    }

    public final int arrayOffset() {
        return 0;
    }

    public int hashCode() {
        return super.hashCode();
    }

    public boolean equals(Object object) {
        if (object instanceof FloatBuffer) {
            return this.compareTo(object) == 0;
        }
        return false;
    }

    @Override
    public int compareTo(Object object) {
        FloatBuffer floatBuffer = (FloatBuffer)object;
        if (floatBuffer.remaining() != this.remaining()) {
            return 1;
        }
        if (!this.hasArray() || !floatBuffer.hasArray()) {
            return 1;
        }
        int n = this.remaining();
        int n2 = this.position();
        int n3 = floatBuffer.position();
        int n4 = 0;
        while (n4 < n) {
            int n5 = (int)(this.get(n2) - floatBuffer.get(n3));
            if (n5 != 0) {
                return n5;
            }
            ++n4;
        }
        return 0;
    }

    public ByteOrder order() {
        return this.endian;
    }

    public final FloatBuffer order(ByteOrder byteOrder) {
        this.endian = byteOrder;
        return this;
    }

    public abstract float get();

    public abstract FloatBuffer put(float var1);

    public abstract float get(int var1);

    public abstract FloatBuffer put(int var1, float var2);

    public abstract FloatBuffer compact();

    public abstract boolean isDirect();

    public abstract FloatBuffer slice();

    public abstract FloatBuffer duplicate();

    public abstract FloatBuffer asReadOnlyBuffer();

    public FloatBuffer() {
        this.Block$();
    }

    private /* synthetic */ void Block$() {
        this.endian = ByteOrder.BIG_ENDIAN;
    }
}

