/*
 * Decompiled with CFR 0.152.
 */
package java.nio;

import gnu.java.nio.IntBufferImpl;
import java.nio.Buffer;
import java.nio.ByteOrder;

/*
 * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class IntBuffer
extends Buffer
implements Comparable {
    private ByteOrder endian;
    protected int[] backing_buffer;

    public static IntBuffer allocateDirect(int n) {
        return new IntBufferImpl(n, 0, n);
    }

    public static IntBuffer allocate(int n) {
        return new IntBufferImpl(n, 0, n);
    }

    public static final IntBuffer wrap(int[] nArray, int n, int n2) {
        return new IntBufferImpl(nArray, n, n2);
    }

    public static final IntBuffer wrap(String string) {
        int n = string.length();
        int[] nArray = new int[n];
        int n2 = 0;
        while (n2 < n) {
            nArray[n2] = string.charAt(n2);
            ++n2;
        }
        return IntBuffer.wrap(nArray, 0, n);
    }

    public static final IntBuffer wrap(int[] nArray) {
        return IntBuffer.wrap(nArray, 0, nArray.length);
    }

    public IntBuffer get(int[] nArray, int n, int n2) {
        int n3 = n;
        while (n3 < n + n2) {
            nArray[n3] = this.get();
            ++n3;
        }
        return this;
    }

    public IntBuffer get(int[] nArray) {
        return this.get(nArray, 0, nArray.length);
    }

    public IntBuffer put(IntBuffer intBuffer) {
        while (intBuffer.hasRemaining()) {
            this.put(intBuffer.get());
        }
        return this;
    }

    public IntBuffer put(int[] nArray, int n, int n2) {
        int n3 = n;
        while (n3 < n + n2) {
            this.put(nArray[n3]);
            ++n3;
        }
        return this;
    }

    public final IntBuffer put(int[] nArray) {
        return this.put(nArray, 0, nArray.length);
    }

    public final boolean hasArray() {
        return this.backing_buffer != null;
    }

    public final int[] array() {
        return this.backing_buffer;
    }

    public final int arrayOffset() {
        return 0;
    }

    public int hashCode() {
        return super.hashCode();
    }

    public boolean equals(Object object) {
        if (object instanceof IntBuffer) {
            return this.compareTo(object) == 0;
        }
        return false;
    }

    @Override
    public int compareTo(Object object) {
        IntBuffer intBuffer = (IntBuffer)object;
        if (intBuffer.remaining() != this.remaining()) {
            return 1;
        }
        if (!this.hasArray() || !intBuffer.hasArray()) {
            return 1;
        }
        int n = this.remaining();
        int n2 = this.position();
        int n3 = intBuffer.position();
        int n4 = 0;
        while (n4 < n) {
            int n5 = this.get(n2) - intBuffer.get(n3);
            if (n5 != 0) {
                return n5;
            }
            ++n4;
        }
        return 0;
    }

    public ByteOrder order() {
        return this.endian;
    }

    public final IntBuffer order(ByteOrder byteOrder) {
        this.endian = byteOrder;
        return this;
    }

    public abstract int get();

    public abstract IntBuffer put(int var1);

    public abstract int get(int var1);

    public abstract IntBuffer put(int var1, int var2);

    public abstract IntBuffer compact();

    public abstract boolean isDirect();

    public abstract IntBuffer slice();

    public abstract IntBuffer duplicate();

    public abstract IntBuffer asReadOnlyBuffer();

    public IntBuffer() {
        this.Block$();
    }

    private /* synthetic */ void Block$() {
        this.endian = ByteOrder.BIG_ENDIAN;
    }
}

