/*
 * Decompiled with CFR 0.152.
 */
package java.nio;

import gnu.java.nio.LongBufferImpl;
import java.nio.Buffer;
import java.nio.ByteOrder;

/*
 * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class LongBuffer
extends Buffer
implements Comparable {
    private ByteOrder endian;
    protected long[] backing_buffer;

    public static LongBuffer allocateDirect(int n) {
        return new LongBufferImpl(n, 0, n);
    }

    public static LongBuffer allocate(int n) {
        return new LongBufferImpl(n, 0, n);
    }

    public static final LongBuffer wrap(long[] lArray, int n, int n2) {
        return new LongBufferImpl(lArray, n, n2);
    }

    public static final LongBuffer wrap(String string) {
        int n = string.length();
        long[] lArray = new long[n];
        int n2 = 0;
        while (n2 < n) {
            lArray[n2] = string.charAt(n2);
            ++n2;
        }
        return LongBuffer.wrap(lArray, 0, n);
    }

    public static final LongBuffer wrap(long[] lArray) {
        return LongBuffer.wrap(lArray, 0, lArray.length);
    }

    public LongBuffer get(long[] lArray, int n, int n2) {
        int n3 = n;
        while (n3 < n + n2) {
            lArray[n3] = this.get();
            ++n3;
        }
        return this;
    }

    public LongBuffer get(long[] lArray) {
        return this.get(lArray, 0, lArray.length);
    }

    public LongBuffer put(LongBuffer longBuffer) {
        while (longBuffer.hasRemaining()) {
            this.put(longBuffer.get());
        }
        return this;
    }

    public LongBuffer put(long[] lArray, int n, int n2) {
        int n3 = n;
        while (n3 < n + n2) {
            this.put(lArray[n3]);
            ++n3;
        }
        return this;
    }

    public final LongBuffer put(long[] lArray) {
        return this.put(lArray, 0, lArray.length);
    }

    public final boolean hasArray() {
        return this.backing_buffer != null;
    }

    public final long[] array() {
        return this.backing_buffer;
    }

    public final int arrayOffset() {
        return 0;
    }

    public int hashCode() {
        return super.hashCode();
    }

    public boolean equals(Object object) {
        if (object instanceof LongBuffer) {
            return this.compareTo(object) == 0;
        }
        return false;
    }

    @Override
    public int compareTo(Object object) {
        LongBuffer longBuffer = (LongBuffer)object;
        if (longBuffer.remaining() != this.remaining()) {
            return 1;
        }
        if (!this.hasArray() || !longBuffer.hasArray()) {
            return 1;
        }
        int n = this.remaining();
        int n2 = this.position();
        int n3 = longBuffer.position();
        int n4 = 0;
        while (n4 < n) {
            int n5 = (int)(this.get(n2) - longBuffer.get(n3));
            if (n5 != 0) {
                return n5;
            }
            ++n4;
        }
        return 0;
    }

    public ByteOrder order() {
        return this.endian;
    }

    public final LongBuffer order(ByteOrder byteOrder) {
        this.endian = byteOrder;
        return this;
    }

    public abstract long get();

    public abstract LongBuffer put(long var1);

    public abstract long get(int var1);

    public abstract LongBuffer put(int var1, long var2);

    public abstract LongBuffer compact();

    public abstract boolean isDirect();

    public abstract LongBuffer slice();

    public abstract LongBuffer duplicate();

    public abstract LongBuffer asReadOnlyBuffer();

    public LongBuffer() {
        this.Block$();
    }

    private /* synthetic */ void Block$() {
        this.endian = ByteOrder.BIG_ENDIAN;
    }
}

