/*
 * Decompiled with CFR 0.152.
 */
package java.nio;

import gnu.java.nio.ShortBufferImpl;
import java.nio.Buffer;
import java.nio.ByteOrder;

/*
 * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ShortBuffer
extends Buffer
implements Comparable {
    private ByteOrder endian;
    protected short[] backing_buffer;

    public static ShortBuffer allocateDirect(int n) {
        return new ShortBufferImpl(n, 0, n);
    }

    public static ShortBuffer allocate(int n) {
        return new ShortBufferImpl(n, 0, n);
    }

    public static final ShortBuffer wrap(short[] sArray, int n, int n2) {
        return new ShortBufferImpl(sArray, n, n2);
    }

    public static final ShortBuffer wrap(String string) {
        int n = string.length();
        short[] sArray = new short[n];
        int n2 = 0;
        while (n2 < n) {
            sArray[n2] = (short)string.charAt(n2);
            ++n2;
        }
        return ShortBuffer.wrap(sArray, 0, n);
    }

    public static final ShortBuffer wrap(short[] sArray) {
        return ShortBuffer.wrap(sArray, 0, sArray.length);
    }

    public ShortBuffer get(short[] sArray, int n, int n2) {
        int n3 = n;
        while (n3 < n + n2) {
            sArray[n3] = this.get();
            ++n3;
        }
        return this;
    }

    public ShortBuffer get(short[] sArray) {
        return this.get(sArray, 0, sArray.length);
    }

    public ShortBuffer put(ShortBuffer shortBuffer) {
        while (shortBuffer.hasRemaining()) {
            this.put(shortBuffer.get());
        }
        return this;
    }

    public ShortBuffer put(short[] sArray, int n, int n2) {
        int n3 = n;
        while (n3 < n + n2) {
            this.put(sArray[n3]);
            ++n3;
        }
        return this;
    }

    public final ShortBuffer put(short[] sArray) {
        return this.put(sArray, 0, sArray.length);
    }

    public final boolean hasArray() {
        return this.backing_buffer != null;
    }

    public final short[] array() {
        return this.backing_buffer;
    }

    public final int arrayOffset() {
        return 0;
    }

    public int hashCode() {
        return super.hashCode();
    }

    public boolean equals(Object object) {
        if (object instanceof ShortBuffer) {
            return this.compareTo(object) == 0;
        }
        return false;
    }

    @Override
    public int compareTo(Object object) {
        ShortBuffer shortBuffer = (ShortBuffer)object;
        if (shortBuffer.remaining() != this.remaining()) {
            return 1;
        }
        if (!this.hasArray() || !shortBuffer.hasArray()) {
            return 1;
        }
        int n = this.remaining();
        int n2 = this.position();
        int n3 = shortBuffer.position();
        int n4 = 0;
        while (n4 < n) {
            int n5 = this.get(n2) - shortBuffer.get(n3);
            if (n5 != 0) {
                return n5;
            }
            ++n4;
        }
        return 0;
    }

    public ByteOrder order() {
        return this.endian;
    }

    public final ShortBuffer order(ByteOrder byteOrder) {
        this.endian = byteOrder;
        return this;
    }

    public abstract short get();

    public abstract ShortBuffer put(short var1);

    public abstract short get(int var1);

    public abstract ShortBuffer put(int var1, short var2);

    public abstract ShortBuffer compact();

    public abstract boolean isDirect();

    public abstract ShortBuffer slice();

    public abstract ShortBuffer duplicate();

    public abstract ShortBuffer asReadOnlyBuffer();

    public ShortBuffer() {
        this.Block$();
    }

    private /* synthetic */ void Block$() {
        this.endian = ByteOrder.BIG_ENDIAN;
    }
}

