/*
 * Decompiled with CFR 0.152.
 */
package java.nio.channels.spi;

import java.io.IOException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.spi.AbstractSelector;
import java.nio.channels.spi.SelectorProvider;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;

/*
 * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractSelectableChannel
extends SelectableChannel {
    int registered;
    boolean blocking;
    Object LOCK;
    SelectorProvider provider;
    List keys;

    protected AbstractSelectableChannel(SelectorProvider selectorProvider) {
        this.Block$();
        this.provider = selectorProvider;
    }

    @Override
    public final Object blockingLock() {
        return this.LOCK;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final SelectableChannel configureBlocking(boolean bl) throws IOException {
        Object object = this.LOCK;
        synchronized (object) {
            this.blocking = true;
            this.implConfigureBlocking(bl);
        }
        return this;
    }

    @Override
    protected final void implCloseChannel() throws IOException {
        this.implCloseSelectableChannel();
    }

    protected abstract void implCloseSelectableChannel() throws IOException;

    protected abstract void implConfigureBlocking(boolean var1) throws IOException;

    @Override
    public final boolean isBlocking() {
        return this.blocking;
    }

    @Override
    public final boolean isRegistered() {
        return this.registered > 0;
    }

    @Override
    public final SelectionKey keyFor(Selector selector) {
        try {
            return this.register(selector, 0, null);
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Override
    public final SelectorProvider provider() {
        return this.provider;
    }

    private SelectionKey locate(Selector selector) {
        if (this.keys == null) {
            return null;
        }
        SelectionKey selectionKey = null;
        ListIterator listIterator = this.keys.listIterator();
        while (listIterator.hasNext()) {
            selectionKey = (SelectionKey)listIterator.next();
            if (selectionKey.selector() != selector) continue;
            return selectionKey;
        }
        return selectionKey;
    }

    private void add(SelectionKey selectionKey) {
        if (this.keys == null) {
            this.keys = new LinkedList();
        }
        this.keys.add(selectionKey);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final SelectionKey register(Selector selector, int n, Object object) throws ClosedChannelException {
        if (!this.isOpen()) {
            throw new ClosedChannelException();
        }
        SelectionKey selectionKey = null;
        AbstractSelector abstractSelector = (AbstractSelector)selector;
        Object object2 = this.LOCK;
        synchronized (object2) {
            selectionKey = this.locate(abstractSelector);
            if (selectionKey != null) {
                selectionKey.attach(object);
            } else {
                selectionKey = abstractSelector.register(this, n, object);
                if (selectionKey != null) {
                    this.add(selectionKey);
                }
            }
        }
        return selectionKey;
    }

    private /* synthetic */ void Block$() {
        this.blocking = true;
        this.LOCK = new Object();
    }
}

