/*
 * Decompiled with CFR 0.152.
 */
package java.rmi.server;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.Serializable;

/*
 * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class UID
implements Serializable {
    private static final long serialVersionUID = 1086053664494604050L;
    private static final Object lock = Class.forName("java.rmi.server.UID");
    private static long baseTime = System.currentTimeMillis();
    private static short nextCount = Short.MIN_VALUE;
    private static final int uniqueNr = new Object().hashCode();
    private int unique;
    private long time;
    private short count;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UID() {
        Object object = lock;
        synchronized (object) {
            if (this.count == Short.MAX_VALUE) {
                long l;
                while ((l = System.currentTimeMillis()) - baseTime <= 1000L) {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
                baseTime = l;
                nextCount = Short.MIN_VALUE;
            }
            short s = nextCount;
            nextCount = (short)(s + 1);
            this.count = s;
            this.unique = uniqueNr;
            this.time = baseTime;
            return;
        }
    }

    public UID(short s) {
        this.unique = s;
        this.time = 0L;
        this.count = 0;
    }

    public int hashCode() {
        return this.unique;
    }

    public boolean equals(Object object) {
        if (object instanceof UID) {
            UID uID = (UID)object;
            if (this.unique == uID.unique && this.time == uID.time && this.count == uID.count) {
                return true;
            }
        }
        return false;
    }

    public String toString() {
        return new StringBuffer().append("[UID: ").append(this.unique).append(",").append(this.time).append(",").append(this.count).append("]").toString();
    }

    public void write(DataOutput dataOutput) throws IOException {
        dataOutput.writeInt(this.unique);
        dataOutput.writeLong(this.time);
        dataOutput.writeShort(this.count);
    }

    public static UID read(DataInput dataInput) throws IOException {
        UID uID = new UID();
        uID.unique = dataInput.readInt();
        uID.time = dataInput.readLong();
        uID.count = dataInput.readShort();
        return uID;
    }
}

