/*
 * Decompiled with CFR 0.152.
 */
package java.security;

import java.security.AlgorithmParameterGeneratorSpi;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import kaffe.security.Engine;

/*
 * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AlgorithmParameterGenerator {
    private static final String ENGINE_CLASS = "AlgorithmParameterGenerator";
    private AlgorithmParameterGeneratorSpi paramGenSpi;
    private Provider provider;
    private String algorithm;

    protected AlgorithmParameterGenerator(AlgorithmParameterGeneratorSpi algorithmParameterGeneratorSpi, Provider provider, String string) {
        this.paramGenSpi = algorithmParameterGeneratorSpi;
        this.provider = provider;
        this.algorithm = string;
    }

    public final Provider getProvider() {
        return this.provider;
    }

    public final String getAlgorithm() {
        return this.algorithm;
    }

    public final void init(int n) {
        this.paramGenSpi.engineInit(n, new SecureRandom());
    }

    public final void init(int n, SecureRandom secureRandom) {
        this.paramGenSpi.engineInit(n, secureRandom);
    }

    public final void init(AlgorithmParameterSpec algorithmParameterSpec) throws InvalidAlgorithmParameterException {
        this.paramGenSpi.engineInit(algorithmParameterSpec, new SecureRandom());
    }

    public final void init(AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidAlgorithmParameterException {
        this.paramGenSpi.engineInit(algorithmParameterSpec, secureRandom);
    }

    public final AlgorithmParameters generateParameters() {
        return this.paramGenSpi.engineGenerateParameters();
    }

    public static AlgorithmParameterGenerator getInstance(String string) throws NoSuchAlgorithmException {
        return AlgorithmParameterGenerator.getInstance(Engine.getCryptInstance(ENGINE_CLASS, string));
    }

    public static AlgorithmParameterGenerator getInstance(String string, String string2) throws NoSuchAlgorithmException, NoSuchProviderException {
        return AlgorithmParameterGenerator.getInstance(Engine.getCryptInstance(ENGINE_CLASS, string, string2));
    }

    private static AlgorithmParameterGenerator getInstance(Engine engine) {
        AlgorithmParameterGeneratorSpi algorithmParameterGeneratorSpi = (AlgorithmParameterGeneratorSpi)engine.getEngine();
        AlgorithmParameterGenerator algorithmParameterGenerator = new AlgorithmParameterGenerator(algorithmParameterGeneratorSpi, engine.getProvider(), engine.getAlgorithm());
        return algorithmParameterGenerator;
    }
}

