/*
 * Decompiled with CFR 0.152.
 */
package java.security;

import java.io.Serializable;
import java.security.Certificate;
import java.security.IdentityScope;
import java.security.KeyManagementException;
import java.security.Principal;
import java.security.PublicKey;
import java.util.ArrayList;
import java.util.Collection;

/*
 * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Identity
implements Principal,
Serializable {
    private String name;
    private IdentityScope scope;
    private Collection certs;
    private String info;
    private PublicKey key;
    private static final Certificate[] CERTIFICATE_ARRAY_DUMMY = new Certificate[0];

    public Identity() {
        this.Block$();
    }

    public Identity(String string) {
        this.Block$();
        this.name = string;
    }

    public Identity(String string, IdentityScope identityScope) throws KeyManagementException {
        this.Block$();
        if (identityScope.getIdentity(string) != null) {
            throw new KeyManagementException(new StringBuffer().append("There is already an identity ").append(string).append(" in identity scope ").append(identityScope).toString());
        }
        this.name = string;
        this.scope = identityScope;
    }

    public void addCertificate(Certificate certificate) throws KeyManagementException {
        if (this.getPublicKey() != null) {
            if (this.getPublicKey() != certificate.getPublicKey()) {
                throw new KeyManagementException("Public key in the certificate being added conflicts with identity's public key");
            }
        } else {
            this.setPublicKey(certificate.getPublicKey());
        }
        this.certs.add(certificate);
    }

    public Certificate[] certificates() {
        return (Certificate[])this.certs.toArray(CERTIFICATE_ARRAY_DUMMY);
    }

    @Override
    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof Identity) {
            Identity identity = (Identity)object;
            if (identity.getName() == this.getName() && identity.getScope() == this.getScope()) {
                return true;
            }
            return this.identityEquals(identity);
        }
        return false;
    }

    public String getInfo() {
        return this.info;
    }

    @Override
    public final String getName() {
        return this.name;
    }

    public PublicKey getPublicKey() {
        return this.key;
    }

    public final IdentityScope getScope() {
        return this.scope;
    }

    @Override
    public int hashCode() {
        return (this.name == null ? 0 : this.getName().hashCode()) + (this.scope == null ? 0 : this.getScope().hashCode());
    }

    protected boolean identityEquals(Identity identity) {
        return this.getName() == identity.getName() && this.getPublicKey() == identity.getPublicKey();
    }

    public void removeCertificate(Certificate certificate) throws KeyManagementException {
        if (!this.certs.remove(certificate)) {
            throw new KeyManagementException(new StringBuffer().append("Certificate ").append(certificate).append(" is missing, so it can not be removed").toString());
        }
    }

    public void setInfo(String string) {
        this.info = string;
    }

    public void setPublicKey(PublicKey publicKey) throws KeyManagementException {
        if (this.getScope() != null && this.getScope().getIdentity(publicKey) != null) {
            throw new KeyManagementException(new StringBuffer().append("There is already an identity in identity scope ").append(this.scope).append(" with public key ").append(publicKey).toString());
        }
        this.key = publicKey;
        this.certs = new ArrayList();
    }

    @Override
    public String toString() {
        return new StringBuffer().append("java.security.Identity[name=").append(this.name).append(",scope=").append(this.scope).append(']').toString();
    }

    public String toString(boolean bl) {
        if (bl) {
            return new StringBuffer().append("java.security.Identity[name=").append(this.name).append(",scope=").append(this.scope).append(",info=").append(this.info).append(",key=").append(this.key).append(",certificates=").append(this.certs).append(']').toString();
        }
        return this.toString();
    }

    private /* synthetic */ void Block$() {
        this.certs = new ArrayList();
    }
}

