/*
 * Decompiled with CFR 0.152.
 */
package java.security;

import java.security.DigestException;
import java.security.MessageDigestSpi;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.util.Arrays;
import kaffe.security.Engine;

/*
 * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class MessageDigest
extends MessageDigestSpi {
    private static final String ENGINE_CLASS = "MessageDigest";
    private final String algorithm;
    private Provider provider;

    protected MessageDigest(String string) {
        this.algorithm = string;
    }

    public static MessageDigest getInstance(String string) throws NoSuchAlgorithmException {
        return MessageDigest.getInstance(Engine.getCryptInstance(ENGINE_CLASS, string));
    }

    public static MessageDigest getInstance(String string, String string2) throws NoSuchAlgorithmException, NoSuchProviderException {
        return MessageDigest.getInstance(Engine.getCryptInstance(ENGINE_CLASS, string, string2));
    }

    private static MessageDigest getInstance(Engine engine) {
        MessageDigest messageDigest = (MessageDigest)engine.getEngine();
        messageDigest.provider = engine.getProvider();
        return messageDigest;
    }

    public final Provider getProvider() {
        return this.provider;
    }

    public void update(byte by) {
        this.engineUpdate(by);
    }

    public void update(byte[] byArray, int n, int n2) {
        this.engineUpdate(byArray, n, n2);
    }

    public void update(byte[] byArray) {
        this.update(byArray, 0, byArray.length);
    }

    public byte[] digest() {
        byte[] byArray = this.engineDigest();
        this.engineReset();
        return byArray;
    }

    public int digest(byte[] byArray, int n, int n2) throws DigestException {
        int n3 = this.engineGetDigestLength();
        if (n2 < n3) {
            throw new DigestException(new StringBuffer().append("buf.length < ").append(n3).toString());
        }
        System.arraycopy(this.digest(), 0, byArray, n, n3);
        return n3;
    }

    public byte[] digest(byte[] byArray) {
        this.update(byArray);
        return this.digest();
    }

    public String toString() {
        return super.toString();
    }

    public static boolean isEqual(byte[] byArray, byte[] byArray2) {
        return Arrays.equals(byArray, byArray2);
    }

    public void reset() {
        this.engineReset();
    }

    public final String getAlgorithm() {
        return this.algorithm;
    }

    public final int getDigestLength() {
        return this.engineGetDigestLength();
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }
}

