/*
 * Decompiled with CFR 0.152.
 */
package java.security;

import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.SecureRandomSpi;
import java.util.Random;
import kaffe.security.Engine;

/*
 * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SecureRandom
extends Random {
    static final String ENGINE_CLASS = "SecureRandom";
    private final Provider provider;
    private final SecureRandomSpi engine;

    public SecureRandom() {
        try {
            Engine engine = Engine.getCryptInstance(ENGINE_CLASS);
            this.provider = engine.getProvider();
            this.engine = (SecureRandomSpi)engine.getEngine();
            return;
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new Error("no SecureRandom found");
        }
    }

    public SecureRandom(byte[] byArray) {
        this();
        this.setSeed(byArray);
    }

    protected SecureRandom(SecureRandomSpi secureRandomSpi, Provider provider) {
        this.engine = secureRandomSpi;
        this.provider = provider;
    }

    public static SecureRandom getInstance(String string) throws NoSuchAlgorithmException {
        Engine engine = Engine.getCryptInstance(ENGINE_CLASS, string);
        return new SecureRandom((SecureRandomSpi)engine.getEngine(), engine.getProvider());
    }

    public static SecureRandom getInstance(String string, String string2) throws NoSuchAlgorithmException, NoSuchProviderException {
        Engine engine = Engine.getCryptInstance(ENGINE_CLASS, string, string2);
        return new SecureRandom((SecureRandomSpi)engine.getEngine(), engine.getProvider());
    }

    public final Provider getProvider() {
        return this.provider;
    }

    public void setSeed(byte[] byArray) {
        if (this.engine != null) {
            this.engine.engineSetSeed(byArray);
        }
    }

    @Override
    public void setSeed(long l) {
        byte[] byArray = new byte[8];
        int n = 0;
        while (n < 8) {
            byArray[n] = (byte)(l >> n * 8);
            ++n;
        }
        this.setSeed(byArray);
    }

    @Override
    public void nextBytes(byte[] byArray) {
        this.engine.engineNextBytes(byArray);
    }

    @Override
    protected final int next(int n) {
        byte[] byArray = new byte[(n + 7) / 8];
        this.nextBytes(byArray);
        return byArray[0] & 0xFF | byArray[1] << 8 & 0xFF00 | byArray[2] << 16 & 0xFF0000 | byArray[3] << 24 & 0xFF000000;
    }

    public static byte[] getSeed(int n) {
        new SecureRandom();
        return SecureRandom.getSeed(n);
    }

    public byte[] generateSeed(int n) {
        return this.engine.engineGenerateSeed(n);
    }
}

