/*
 * Decompiled with CFR 0.152.
 */
package java.security.cert;

import java.io.ObjectStreamException;
import java.io.Serializable;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PublicKey;
import java.security.SignatureException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;

/*
 * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Certificate
implements Serializable {
    private String type;

    protected Certificate(String string) {
        this.type = string;
    }

    public abstract byte[] getEncoded() throws CertificateEncodingException;

    public abstract PublicKey getPublicKey();

    public String getType() {
        return this.type;
    }

    public boolean equals(Object object) {
        boolean bl = false;
        if (object instanceof Certificate) {
            Certificate certificate = (Certificate)object;
            try {
                byte[] byArray = certificate.getEncoded();
                byte[] byArray2 = this.getEncoded();
                if (byArray != null && byArray2 != null && byArray.length == byArray2.length) {
                    bl = true;
                    int n = 0;
                    while (n < byArray.length && bl) {
                        if (byArray[n] != byArray2[n]) {
                            bl = false;
                        }
                        ++n;
                    }
                }
            }
            catch (CertificateEncodingException certificateEncodingException) {
                // empty catch block
            }
        }
        return bl;
    }

    public int hashCode() {
        int n = 0;
        try {
            byte[] byArray = this.getEncoded();
            if (byArray != null) {
                switch (byArray.length) {
                    case 1: {
                        n = byArray[0];
                        break;
                    }
                    case 2: {
                        n = byArray[0] << 8 | byArray[1];
                        break;
                    }
                    case 3: {
                        n = byArray[0] << 16 | byArray[1] << 8 | byArray[2];
                        break;
                    }
                    default: {
                        n = byArray[0] << 24 | byArray[1] << 16 | byArray[2] << 8 | byArray[3];
                        break;
                    }
                }
            }
        }
        catch (CertificateEncodingException certificateEncodingException) {
            // empty catch block
        }
        return n;
    }

    public abstract String toString();

    public abstract void verify(PublicKey var1) throws CertificateException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, SignatureException;

    public abstract void verify(PublicKey var1, String var2) throws CertificateException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, SignatureException;

    protected Object writeReplace() throws ObjectStreamException {
        try {
            return new CertificateRep(this.type, this.getEncoded());
        }
        catch (CertificateEncodingException certificateEncodingException) {
            return null;
        }
    }

    /*
     * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class CertificateRep
    implements Serializable {
        private String type;
        private byte[] data;

        protected CertificateRep(String string, byte[] byArray) {
            this.type = string;
            this.data = byArray;
        }

        protected Object readResolve() throws ObjectStreamException {
            return null;
        }
    }
}

