/*
 * Decompiled with CFR 0.152.
 */
package java.security.spec;

import java.math.BigInteger;
import java.security.interfaces.DSAParams;
import java.security.spec.AlgorithmParameterSpec;

/*
 * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DSAParameterSpec
implements AlgorithmParameterSpec,
DSAParams {
    private final BigInteger p;
    private final BigInteger q;
    private final BigInteger g;

    public DSAParameterSpec(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3) {
        if (bigInteger.signum() < 0) {
            throw new IllegalArgumentException();
        }
        if (bigInteger2.signum() < 0) {
            throw new IllegalArgumentException();
        }
        if (bigInteger3.signum() < 0) {
            throw new IllegalArgumentException();
        }
        this.p = bigInteger;
        this.q = bigInteger2;
        this.g = bigInteger3;
    }

    @Override
    public BigInteger getP() {
        return this.p;
    }

    @Override
    public BigInteger getQ() {
        return this.q;
    }

    @Override
    public BigInteger getG() {
        return this.g;
    }

    public String toString() {
        return new StringBuffer().append("DSAParameterSpec[p=").append(this.p).append("; q=").append(this.q).append("; g=").append(this.g).append("]").toString();
    }
}

