/*
 * Decompiled with CFR 0.152.
 */
package java.security.spec;

import java.math.BigInteger;
import java.security.spec.KeySpec;

/*
 * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DSAPublicKeySpec
implements KeySpec {
    private final BigInteger y;
    private final BigInteger p;
    private final BigInteger q;
    private final BigInteger g;

    public DSAPublicKeySpec(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3, BigInteger bigInteger4) {
        if (bigInteger.signum() < 0) {
            throw new IllegalArgumentException();
        }
        if (bigInteger2.signum() < 0) {
            throw new IllegalArgumentException();
        }
        if (bigInteger3.signum() < 0) {
            throw new IllegalArgumentException();
        }
        if (bigInteger4.signum() < 0) {
            throw new IllegalArgumentException();
        }
        this.y = bigInteger;
        this.p = bigInteger2;
        this.q = bigInteger3;
        this.g = bigInteger4;
    }

    public BigInteger getY() {
        return this.y;
    }

    public BigInteger getP() {
        return this.p;
    }

    public BigInteger getQ() {
        return this.q;
    }

    public BigInteger getG() {
        return this.g;
    }

    public String toString() {
        return new StringBuffer().append("DSAPublicKeySpec[y=").append(this.y).append("; p=").append(this.p).append("; q=").append(this.q).append("; g=").append(this.g).append("]").toString();
    }
}

