/*
 * Decompiled with CFR 0.152.
 */
package java.text;

import java.text.CharacterIterator;
import java.text.StringCharacterIterator;

/*
 * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CollationElementIterator {
    public static final int NULLORDER = -1;
    private CharacterIterator src;

    CollationElementIterator(String string) {
        this.src = new StringCharacterIterator(string);
    }

    CollationElementIterator(CharacterIterator characterIterator) {
        this.src = characterIterator;
    }

    public void reset() {
        this.src.setIndex(0);
    }

    public int next() {
        char c = this.src.next();
        if (c == '\uffff') {
            return -1;
        }
        return c << 16;
    }

    public int previous() {
        char c = this.src.previous();
        if (c == '\uffff') {
            return -1;
        }
        return c << 16;
    }

    public static final int primaryOrder(int n) {
        return n >> 16;
    }

    public static final short secondaryOrder(int n) {
        return (short)(n >> 8 & 0xFF);
    }

    public static final short tertiaryOrder(int n) {
        return (short)(n & 0xFF);
    }

    public void setOffset(int n) {
        this.src.setIndex(n);
    }

    public int getOffset() {
        return this.src.getIndex();
    }

    public int getMaxExpansion(int n) {
        return 1;
    }

    public void setText(String string) {
        this.src = new StringCharacterIterator(string);
    }

    public void setText(CharacterIterator characterIterator) {
        this.src = characterIterator;
    }
}

