/*
 * Decompiled with CFR 0.152.
 */
package java.text;

import java.io.Serializable;
import java.text.Format;
import java.util.Locale;
import java.util.ResourceBundle;

/*
 * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DecimalFormatSymbols
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 5772796243397350300L;
    char digit;
    char patternSeparator;
    char zeroDigit;
    char groupSeparator;
    char decimalSeparator;
    char percentSign;
    char permillSign;
    char minusSign;
    String infinity;
    String nan;
    char currencySign;

    public DecimalFormatSymbols() {
        this(Locale.getDefault());
    }

    public DecimalFormatSymbols(Locale locale2) {
        ResourceBundle resourceBundle = Format.getResources("numberformat", locale2);
        this.digit = resourceBundle.getString("#").charAt(0);
        this.patternSeparator = resourceBundle.getString(";").charAt(0);
        this.zeroDigit = resourceBundle.getString("0").charAt(0);
        this.groupSeparator = resourceBundle.getString(",").charAt(0);
        this.decimalSeparator = resourceBundle.getString(".").charAt(0);
        this.percentSign = resourceBundle.getString("%").charAt(0);
        this.permillSign = resourceBundle.getString("\u2030").charAt(0);
        this.minusSign = resourceBundle.getString("-").charAt(0);
        this.infinity = resourceBundle.getString("\u221e");
        this.nan = resourceBundle.getString("\ufffd");
        this.currencySign = resourceBundle.getString("\u00a4").charAt(0);
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public boolean equals(Object object) {
        if (object instanceof DecimalFormatSymbols) {
            DecimalFormatSymbols decimalFormatSymbols = (DecimalFormatSymbols)object;
            if (this.digit == decimalFormatSymbols.digit && this.patternSeparator == decimalFormatSymbols.patternSeparator && this.zeroDigit == decimalFormatSymbols.zeroDigit && this.groupSeparator == decimalFormatSymbols.groupSeparator && this.decimalSeparator == decimalFormatSymbols.decimalSeparator && this.percentSign == decimalFormatSymbols.percentSign && this.permillSign == decimalFormatSymbols.permillSign && this.minusSign == decimalFormatSymbols.minusSign && this.infinity.equals(decimalFormatSymbols.infinity) && this.nan.equals(decimalFormatSymbols.nan)) {
                return true;
            }
        }
        return false;
    }

    public char getDecimalSeparator() {
        return this.decimalSeparator;
    }

    public char getDigit() {
        return this.digit;
    }

    public char getGroupingSeparator() {
        return this.groupSeparator;
    }

    public String getInfinity() {
        return this.infinity;
    }

    public char getMinusSign() {
        return this.minusSign;
    }

    public String getNaN() {
        return this.nan;
    }

    public char getPatternSeparator() {
        return this.patternSeparator;
    }

    public char getPercent() {
        return this.percentSign;
    }

    public char getPerMill() {
        return this.permillSign;
    }

    public char getZeroDigit() {
        return this.zeroDigit;
    }

    public int hashCode() {
        return super.hashCode();
    }

    public void setDecimalSeparator(char c) {
        this.decimalSeparator = c;
    }

    public void setDigit(char c) {
        this.digit = c;
    }

    public void setGroupingSeparator(char c) {
        this.groupSeparator = c;
    }

    public void setInfinity(String string) {
        this.infinity = string;
    }

    public void setMinusSign(char c) {
        this.minusSign = c;
    }

    public void setNaN(String string) {
        this.nan = string;
    }

    public void setPatternSeparator(char c) {
        this.patternSeparator = c;
    }

    public void setPercent(char c) {
        this.percentSign = c;
    }

    public void setPerMill(char c) {
        this.permillSign = c;
    }

    public void setZeroDigit(char c) {
        this.zeroDigit = c;
    }
}

