/*
 * Decompiled with CFR 0.152.
 */
package java.text;

import java.text.ChoiceFormat;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.FieldPosition;
import java.text.Format;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Locale;
import kaffe.util.NotImplemented;

/*
 * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MessageFormat
extends Format {
    private Locale locale;
    private Format[] formats;
    private int[] argumentNumber;
    private transient String[] strs;
    private int maxOffset;
    private int[] offsets;
    private String pattern;

    public MessageFormat(String string) {
        this.Block$();
        this.applyPattern(string);
    }

    public void applyPattern(String string) {
        int n = string.length();
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            if (string.charAt(n3) == '{') {
                ++n2;
                while (string.charAt(n3) != '}' && n3 < n) {
                    ++n3;
                }
            }
            ++n3;
        }
        this.formats = new Format[n2];
        this.strs = new String[n2 + 1];
        this.argumentNumber = new int[n2];
        n2 = 0;
        n3 = 0;
        int n4 = 0;
        while (n4 < n) {
            if (string.charAt(n4) == '{') {
                this.strs[n2] = string.substring(n3, n4);
                n3 = ++n4;
                while (string.charAt(n4) != '}' && n4 < n) {
                    ++n4;
                }
                this.parseFormat(string.substring(n3, n4), n2);
                ++n2;
                n3 = n4 + 1;
            }
            ++n4;
        }
        this.strs[n2] = string.substring(n3, n);
    }

    private void parseFormat(String string, int n) {
        int n2;
        int n3 = string.indexOf(44);
        int n4 = n3 + 1;
        if (n3 == -1) {
            n4 = n3 = string.length();
        }
        int n5 = string.indexOf(44, n3 + 1);
        int n6 = n5 + 1;
        if (n5 == -1) {
            n6 = n5 = string.length();
        }
        try {
            n2 = Integer.parseInt(string.substring(0, n3));
        }
        catch (NumberFormatException numberFormatException) {
            n2 = -1;
        }
        String string2 = string.substring(n4, n5);
        String string3 = string.substring(n6, string.length());
        this.argumentNumber[n] = n2;
        if (string2.equals("time")) {
            if (string3.equals("")) {
                this.formats[n] = DateFormat.getTimeInstance(2, this.locale);
                return;
            }
            if (string3.equals("short")) {
                this.formats[n] = DateFormat.getTimeInstance(3, this.locale);
                return;
            }
            if (string3.equals("medium")) {
                this.formats[n] = DateFormat.getTimeInstance(2, this.locale);
                return;
            }
            if (string3.equals("long")) {
                this.formats[n] = DateFormat.getTimeInstance(1, this.locale);
                return;
            }
            if (string3.equals("full")) {
                this.formats[n] = DateFormat.getTimeInstance(0, this.locale);
                return;
            }
            this.formats[n] = new SimpleDateFormat(string3, this.locale);
            return;
        }
        if (string2.equals("date")) {
            if (string3.equals("")) {
                this.formats[n] = DateFormat.getDateInstance(2, this.locale);
                return;
            }
            if (string3.equals("short")) {
                this.formats[n] = DateFormat.getDateInstance(3, this.locale);
                return;
            }
            if (string3.equals("medium")) {
                this.formats[n] = DateFormat.getDateInstance(2, this.locale);
                return;
            }
            if (string3.equals("long")) {
                this.formats[n] = DateFormat.getDateInstance(1, this.locale);
                return;
            }
            if (string3.equals("full")) {
                this.formats[n] = DateFormat.getDateInstance(0, this.locale);
                return;
            }
            this.formats[n] = new SimpleDateFormat(string3, this.locale);
            return;
        }
        if (string2.equals("number")) {
            if (string3.equals("currency")) {
                this.formats[n] = NumberFormat.getCurrencyInstance(this.locale);
                return;
            }
            if (string3.equals("percent")) {
                this.formats[n] = NumberFormat.getPercentInstance(this.locale);
                return;
            }
            if (string3.equals("integer")) {
                this.formats[n] = NumberFormat.getNumberInstance(this.locale);
                return;
            }
            this.formats[n] = new DecimalFormat(string3, this.locale);
            return;
        }
        if (string2.equals("choice")) {
            this.formats[n] = new ChoiceFormat(string3);
            return;
        }
        this.formats[n] = null;
    }

    @Override
    public Object clone() {
        MessageFormat messageFormat = new MessageFormat("");
        messageFormat.locale = this.locale;
        messageFormat.strs = this.strs;
        messageFormat.formats = this.formats;
        messageFormat.argumentNumber = this.argumentNumber;
        return messageFormat;
    }

    public boolean equals(Object object) {
        if (object instanceof MessageFormat) {
            MessageFormat messageFormat = (MessageFormat)object;
            if (this.locale != messageFormat.locale) {
                return false;
            }
            int n = this.formats.length;
            while (n-- > 0) {
                if (!this.formats[n].equals(messageFormat.formats[n])) {
                    return false;
                }
                if (this.strs[n].equals(messageFormat.strs[n])) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static String format(String string, Object[] objectArray) {
        return new MessageFormat(string).format(objectArray, new StringBuffer(), (FieldPosition)null).toString();
    }

    public final StringBuffer format(Object[] objectArray, StringBuffer stringBuffer, FieldPosition fieldPosition) {
        FieldPosition fieldPosition2 = new FieldPosition(0);
        int n = 0;
        while (n < this.formats.length) {
            stringBuffer.append(this.strs[n]);
            if (this.formats[n] == null) {
                stringBuffer.append(objectArray[this.argumentNumber[n]].toString());
            } else {
                this.formats[n].format(objectArray[this.argumentNumber[n]], stringBuffer, fieldPosition2);
            }
            ++n;
        }
        stringBuffer.append(this.strs[this.strs.length - 1]);
        return stringBuffer;
    }

    @Override
    public final StringBuffer format(Object object, StringBuffer stringBuffer, FieldPosition fieldPosition) {
        if (object instanceof Object[]) {
            return this.format((Object[])object, stringBuffer, fieldPosition);
        }
        return this.format(new Object[]{object}, stringBuffer, fieldPosition);
    }

    public Format[] getFormats() {
        return this.formats;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public int hashCode() {
        return super.hashCode();
    }

    public Object[] parse(String string, ParsePosition parsePosition) {
        throw new NotImplemented(new StringBuffer().append(Class.forName("java.text.MessageFormat").getName()).append(".parse(String,ParsePosition)").toString());
    }

    public Object[] parse(String string) throws ParseException {
        return this.parse(string, new ParsePosition(0));
    }

    @Override
    public Object parseObject(String string, ParsePosition parsePosition) {
        return this.parse(string, parsePosition);
    }

    public void setFormat(int n, Format format) {
        this.formats[n] = format;
    }

    public void setFormats(Format[] formatArray) {
        this.formats = formatArray;
    }

    public void setLocale(Locale locale2) {
        this.locale = locale2;
    }

    public String toPattern() {
        throw new NotImplemented(new StringBuffer().append(Class.forName("java.text.MessageFormat").getName()).append(".toPattern()").toString());
    }

    private /* synthetic */ void Block$() {
        this.locale = Locale.getDefault();
    }
}

