/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.util.AbstractCollection;
import java.util.AbstractListIterator;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;

/*
 * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractList
extends AbstractCollection
implements List {
    protected int modCount;

    protected AbstractList() {
    }

    @Override
    public boolean add(Object object) {
        this.add(this.size(), object);
        return true;
    }

    @Override
    public abstract Object get(int var1);

    @Override
    public Object set(int n, Object object) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void add(int n, Object object) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object remove(int n) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int indexOf(Object object) {
        ListIterator listIterator = this.listIterator();
        int n = 0;
        while (listIterator.hasNext()) {
            Object object2 = listIterator.next();
            if (!(object != null ? !object.equals(object2) : object2 != null)) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    @Override
    public int lastIndexOf(Object object) {
        ListIterator listIterator = this.listIterator(this.size());
        int n = this.size() - 1;
        while (listIterator.hasPrevious()) {
            Object object2 = listIterator.previous();
            if (!(object != null ? !object.equals(object2) : object2 != null)) {
                return n;
            }
            --n;
        }
        return -1;
    }

    @Override
    public void clear() {
        this.removeRange(0, this.size());
    }

    @Override
    public boolean addAll(int n, Collection collection) {
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            this.add(n++, iterator.next());
        }
        return collection.size() != 0;
    }

    @Override
    public Iterator iterator() {
        return this.listIterator(0);
    }

    @Override
    public ListIterator listIterator() {
        return this.listIterator(0);
    }

    @Override
    public ListIterator listIterator(int n) {
        return new AbstractListIterator(this, n);
    }

    @Override
    public List subList(int n, int n2) {
        if (n < 0 || n2 > this.size()) {
            throw new IndexOutOfBoundsException();
        }
        if (n > n2) {
            throw new IllegalArgumentException();
        }
        return new 1(this, n, n2);
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof List)) {
            return false;
        }
        List list = (List)object;
        if (this.size() != list.size()) {
            return false;
        }
        ListIterator listIterator = this.listIterator();
        ListIterator listIterator2 = list.listIterator();
        while (listIterator.hasNext()) {
            Object object2 = listIterator.next();
            Object object3 = listIterator2.next();
            if (!(object2 == null ? object3 != null : !object2.equals(object3))) continue;
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        int n = 1;
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            Object object = iterator.next();
            n = 31 * n + (object == null ? 0 : object.hashCode());
        }
        return n;
    }

    protected void removeRange(int n, int n2) {
        ListIterator listIterator = this.listIterator(n);
        while (n < n2 && listIterator.hasNext()) {
            listIterator.next();
            listIterator.remove();
            ++n;
        }
    }

    /*
     * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class 1
    extends AbstractList {
        private final AbstractList list;
        protected int modCount;
        private final int off;
        private int len;
        private final /* synthetic */ AbstractList this$0;
        private final /* synthetic */ int var$fromIndex;
        private final /* synthetic */ int var$toIndex;

        @Override
        public int size() {
            return this.len;
        }

        @Override
        public Object get(int n) {
            if (n < 0 || n >= this.len) {
                throw new IndexOutOfBoundsException();
            }
            return this.list.get(this.off + n);
        }

        @Override
        public Object set(int n, Object object) {
            if (this.list.modCount != this.modCount) {
                throw new ConcurrentModificationException();
            }
            if (n < 0 || n >= this.len) {
                throw new IndexOutOfBoundsException();
            }
            return this.list.set(this.off + n, object);
        }

        @Override
        public void add(int n, Object object) {
            if (this.list.modCount != this.modCount) {
                throw new ConcurrentModificationException();
            }
            if (n < 0 || n > this.len) {
                throw new IndexOutOfBoundsException();
            }
            this.list.add(this.off + n, object);
            this.modCount = this.this$0.modCount;
            ++this.len;
        }

        @Override
        public Object remove(int n) {
            if (this.list.modCount != this.modCount) {
                throw new ConcurrentModificationException();
            }
            if (n < 0 || n >= this.len) {
                throw new IndexOutOfBoundsException();
            }
            Object object = this.list.remove(this.off + n);
            this.modCount = this.this$0.modCount;
            this.len += -1;
            return object;
        }

        @Override
        public int indexOf(Object object) {
            if (this.list.modCount != this.modCount) {
                throw new ConcurrentModificationException();
            }
            ListIterator listIterator = this.list.listIterator(this.off);
            int n = 0;
            while (n < this.len && listIterator.hasNext()) {
                Object object2 = listIterator.next();
                if (!(object != null ? !object.equals(object2) : object2 != null)) {
                    return n;
                }
                ++n;
            }
            return -1;
        }

        @Override
        public int lastIndexOf(Object object) {
            if (this.list.modCount != this.modCount) {
                throw new ConcurrentModificationException();
            }
            ListIterator listIterator = this.list.listIterator(this.off + this.len);
            int n = this.len - 1;
            while (n >= 0 && listIterator.hasPrevious()) {
                Object object2 = listIterator.previous();
                if (!(object != null ? !object.equals(object2) : object2 != null)) {
                    return n;
                }
                --n;
            }
            return -1;
        }

        @Override
        protected void removeRange(int n, int n2) {
            if (this.list.modCount != this.modCount) {
                throw new ConcurrentModificationException();
            }
            if (n < 0 || n2 > this.len) {
                throw new IndexOutOfBoundsException();
            }
            this.list.removeRange(this.off + n, this.off + n2);
            this.modCount = this.this$0.modCount;
            this.len -= n2 - n;
        }

        public 1() {
            this.this$0 = var1_1;
            this.var$fromIndex = n;
            this.var$toIndex = n2;
            this.Block$();
        }

        private /* synthetic */ void Block$() {
            this.list = this.this$0;
            this.modCount = this.this$0.modCount;
            this.off = this.var$fromIndex;
            this.len = this.var$toIndex - this.var$fromIndex;
        }
    }
}

