/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.util.AbstractList;
import java.util.ConcurrentModificationException;
import java.util.ListIterator;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
 */
class AbstractListIterator
implements ListIterator {
    protected final AbstractList list;
    protected int lastIndex;
    protected int modCount;
    protected int index;

    AbstractListIterator(AbstractList abstractList, int n) {
        this.Block$();
        if (n < 0 || n > abstractList.size()) {
            throw new IllegalArgumentException();
        }
        this.list = abstractList;
        this.index = n;
        this.modCount = abstractList.modCount;
    }

    @Override
    public int nextIndex() {
        return this.index;
    }

    @Override
    public int previousIndex() {
        return this.index - 1;
    }

    @Override
    public boolean hasNext() {
        return this.index < this.list.size();
    }

    @Override
    public Object next() {
        if (this.list.modCount != this.modCount) {
            throw new ConcurrentModificationException();
        }
        if (this.index >= this.list.size()) {
            throw new NoSuchElementException();
        }
        Object object = this.list.get(this.index);
        this.lastIndex = this.index++;
        return object;
    }

    @Override
    public boolean hasPrevious() {
        return this.index > 0;
    }

    @Override
    public Object previous() {
        if (this.list.modCount != this.modCount) {
            throw new ConcurrentModificationException();
        }
        if (this.index <= 0) {
            throw new NoSuchElementException();
        }
        Object object = this.list.get(this.index - 1);
        this.lastIndex = this.index += -1;
        return object;
    }

    @Override
    public void remove() {
        if (this.list.modCount != this.modCount) {
            throw new ConcurrentModificationException();
        }
        if (this.lastIndex == -1) {
            throw new IllegalStateException();
        }
        this.list.remove(this.lastIndex);
        ++this.modCount;
        if (this.lastIndex < this.index) {
            this.index += -1;
        }
        this.lastIndex = -1;
    }

    @Override
    public void set(Object object) {
        if (this.list.modCount != this.modCount) {
            throw new ConcurrentModificationException();
        }
        if (this.lastIndex == -1) {
            throw new IllegalStateException();
        }
        this.list.set(this.lastIndex, object);
    }

    @Override
    public void add(Object object) {
        if (this.list.modCount != this.modCount) {
            throw new ConcurrentModificationException();
        }
        this.list.add(this.index, object);
        ++this.modCount;
        ++this.index;
    }

    private /* synthetic */ void Block$() {
        this.lastIndex = -1;
    }
}

