/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.Serializable;
import java.text.DateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.TimeZone;

/*
 * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Calendar
implements Serializable,
Cloneable {
    private static final long serialVersionUID = -1807547505821590642L;
    public static final int ERA = 0;
    public static final int YEAR = 1;
    public static final int MONTH = 2;
    public static final int WEEK_OF_YEAR = 3;
    public static final int WEEK_OF_MONTH = 4;
    public static final int DATE = 5;
    public static final int DAY_OF_MONTH = 5;
    public static final int DAY_OF_YEAR = 6;
    public static final int DAY_OF_WEEK = 7;
    public static final int DAY_OF_WEEK_IN_MONTH = 8;
    public static final int AM_PM = 9;
    public static final int HOUR = 10;
    public static final int HOUR_OF_DAY = 11;
    public static final int MINUTE = 12;
    public static final int SECOND = 13;
    public static final int MILLISECOND = 14;
    public static final int ZONE_OFFSET = 15;
    public static final int DST_OFFSET = 16;
    public static final int FIELD_COUNT = 17;
    public static final int SUNDAY = 1;
    public static final int MONDAY = 2;
    public static final int TUESDAY = 3;
    public static final int WEDNESDAY = 4;
    public static final int THURSDAY = 5;
    public static final int FRIDAY = 6;
    public static final int SATURDAY = 7;
    public static final int JANUARY = 0;
    public static final int FEBRUARY = 1;
    public static final int MARCH = 2;
    public static final int APRIL = 3;
    public static final int MAY = 4;
    public static final int JUNE = 5;
    public static final int JULY = 6;
    public static final int AUGUST = 7;
    public static final int SEPTEMBER = 8;
    public static final int OCTOBER = 9;
    public static final int NOVEMBER = 10;
    public static final int DECEMBER = 11;
    public static final int UNDECIMBER = 12;
    public static final int AM = 0;
    public static final int PM = 1;
    private TimeZone zone;
    private Locale locale;
    private boolean lenient = true;
    private int firstdayofweek = 1;
    private int mindaysinfirstweek = 1;
    protected int[] fields = new int[17];
    protected boolean[] isSet = new boolean[17];
    protected long time;
    protected boolean isTimeSet;
    protected boolean areFieldsSet;

    protected Calendar() {
        this(TimeZone.getDefault(), Locale.getDefault());
    }

    protected Calendar(TimeZone timeZone, Locale locale2) {
        this.zone = timeZone;
        this.locale = locale2;
        this.set(15, timeZone.getRawOffset());
    }

    public abstract void add(int var1, int var2);

    public boolean after(Object object) {
        try {
            Calendar calendar = (Calendar)object;
            if (this.getTimeInMillis() > calendar.getTimeInMillis()) {
                return true;
            }
        }
        catch (ClassCastException classCastException) {
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return false;
    }

    private boolean areAllFieldsSet() {
        int n = 0;
        while (n < 17) {
            if (!this.isSet(n)) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public boolean before(Object object) {
        try {
            Calendar calendar = (Calendar)object;
            if (this.getTimeInMillis() < calendar.getTimeInMillis()) {
                return true;
            }
        }
        catch (ClassCastException classCastException) {
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return false;
    }

    public final void clear() {
        Arrays.fill(this.fields, 0);
        Arrays.fill(this.isSet, false);
        this.areFieldsSet = false;
    }

    public final void clear(int n) {
        this.isSet[n] = false;
        this.fields[n] = 0;
        this.areFieldsSet = false;
    }

    public Object clone() {
        Calendar calendar = Calendar.getInstance(this.zone, this.locale);
        System.arraycopy(this.fields, 0, calendar.fields, 0, this.fields.length);
        System.arraycopy(this.isSet, 0, calendar.isSet, 0, this.isSet.length);
        calendar.time = this.time;
        calendar.isTimeSet = this.isTimeSet;
        calendar.areFieldsSet = this.areFieldsSet;
        calendar.lenient = this.lenient;
        calendar.firstdayofweek = this.firstdayofweek;
        calendar.mindaysinfirstweek = this.mindaysinfirstweek;
        return calendar;
    }

    protected void complete() {
        if (!this.isTimeSet) {
            this.computeTime();
        }
        if (!this.areFieldsSet) {
            this.computeFields();
        }
    }

    protected abstract void computeFields();

    protected abstract void computeTime();

    public boolean equals(Object object) {
        if (object instanceof Calendar) {
            Calendar calendar = (Calendar)object;
            return this.isLenient() == calendar.isLenient() && this.getFirstDayOfWeek() == calendar.getFirstDayOfWeek() && this.getMinimalDaysInFirstWeek() == calendar.getMinimalDaysInFirstWeek() && this.getTimeZone() == calendar.getTimeZone() && this.getTime().equals(calendar.getTime());
        }
        return false;
    }

    public final int get(int n) {
        if (!this.isSet[n]) {
            this.complete();
        }
        return this.internalGet(n);
    }

    private int getActualLimit(int n, boolean bl) {
        int n2 = this.get(n);
        int n3 = 0;
        do {
            n3 = this.get(n);
            this.roll(n, bl);
        } while (n3 != this.get(n));
        this.set(n, n2);
        return n3;
    }

    public int getActualMaximum(int n) {
        return this.getActualLimit(n, true);
    }

    public int getActualMinimum(int n) {
        return this.getActualLimit(n, false);
    }

    public static synchronized Locale[] getAvailableLocales() {
        return DateFormat.getAvailableLocales();
    }

    public int getFirstDayOfWeek() {
        return this.firstdayofweek;
    }

    public abstract int getGreatestMinimum(int var1);

    public static synchronized Calendar getInstance() {
        return Calendar.getInstance(TimeZone.getDefault(), Locale.getDefault());
    }

    public static synchronized Calendar getInstance(Locale locale2) {
        return Calendar.getInstance(TimeZone.getDefault(), locale2);
    }

    public static synchronized Calendar getInstance(TimeZone timeZone) {
        return Calendar.getInstance(timeZone, Locale.getDefault());
    }

    public static synchronized Calendar getInstance(TimeZone timeZone, Locale locale2) {
        return new GregorianCalendar(timeZone, locale2);
    }

    public abstract int getLeastMaximum(int var1);

    public abstract int getMaximum(int var1);

    public int getMinimalDaysInFirstWeek() {
        return this.mindaysinfirstweek;
    }

    public abstract int getMinimum(int var1);

    public final Date getTime() {
        return new Date(this.getTimeInMillis());
    }

    protected long getTimeInMillis() {
        if (!this.isTimeSet) {
            this.computeTime();
        }
        return this.time;
    }

    public TimeZone getTimeZone() {
        return this.zone;
    }

    public int hashCode() {
        return this.getFirstDayOfWeek() ^ this.getMinimalDaysInFirstWeek() ^ this.getTimeZone().getRawOffset() ^ (int)this.getTimeInMillis() ^ (this.isLenient() ? -1 : 0);
    }

    protected final int internalGet(int n) {
        return this.fields[n];
    }

    void internalSet(int n, int n2) {
        this.isSet[n] = true;
        this.fields[n] = n2;
    }

    public boolean isLenient() {
        return this.lenient;
    }

    public final boolean isSet(int n) {
        return this.isSet[n];
    }

    public abstract void roll(int var1, boolean var2);

    public void roll(int n, int n2) {
        boolean bl = true;
        if (n2 < 0) {
            n2 = -n2;
            bl = false;
        }
        int n3 = 0;
        while (n3 < n2) {
            this.roll(n, bl);
            ++n3;
        }
    }

    public final void set(int n, int n2) {
        if (this.isLenient()) {
            int n3;
            if (n2 > this.internalGet(n)) {
                int n4 = this.getMaximum(n);
                if (n2 > n4) {
                    n2 = n4;
                }
            } else if (n2 < this.internalGet(n) && n2 < (n3 = this.getMinimum(n))) {
                n2 = n3;
            }
        }
        this.internalSet(n, n2);
        switch (n) {
            case 9: {
                this.clear(11);
                break;
            }
            case 7: {
                if (this.isSet(5)) {
                    this.clear(5);
                    break;
                }
                this.clear(2);
                this.clear(6);
                break;
            }
            case 8: {
                this.clear(5);
                this.clear(4);
                break;
            }
            case 6: {
                this.clear(2);
                break;
            }
            case 10: {
                this.clear(11);
                break;
            }
            case 4: {
                this.clear(5);
                break;
            }
            case 3: {
                this.clear(2);
                this.clear(6);
            }
        }
        this.isTimeSet = false;
        this.areFieldsSet = false;
    }

    public final void set(int n, int n2, int n3) {
        this.set(1, n);
        this.set(2, n2);
        this.set(5, n3);
    }

    public final void set(int n, int n2, int n3, int n4, int n5) {
        this.set(n, n2, n3);
        this.set(11, n4);
        this.set(12, n5);
    }

    public final void set(int n, int n2, int n3, int n4, int n5, int n6) {
        this.set(n, n2, n3, n4, n5);
        this.set(13, n6);
    }

    public void setFirstDayOfWeek(int n) {
        this.firstdayofweek = n;
    }

    public void setLenient(boolean bl) {
        this.lenient = bl;
    }

    public void setMinimalDaysInFirstWeek(int n) {
        this.mindaysinfirstweek = n;
    }

    public final void setTime(Date date) {
        this.setTimeInMillis(date.getTime());
    }

    protected void setTimeInMillis(long l) {
        this.time = l;
        this.isTimeSet = true;
        this.areFieldsSet = false;
        this.computeFields();
    }

    public void setTimeZone(TimeZone timeZone) {
        this.zone = timeZone;
    }

    public String toString() {
        this.complete();
        return new StringBuffer().append(this.getClass().getName()).append("[time=").append(this.getTimeInMillis()).append(",areFieldsSet=").append(this.areFieldsSet).append(",areAllFieldsSet=").append(this.areAllFieldsSet()).append(",lenient=").append(this.isLenient()).append(",zone=").append(this.getTimeZone()).append(",firstDayOfWeek=").append(this.getFirstDayOfWeek()).append(",minimalDaysInFirstWeek=").append(this.getMinimalDaysInFirstWeek()).append(",ERA=").append(this.get(0)).append(",YEAR=").append(this.get(1)).append(",MONTH=").append(this.get(2)).append(",WEEK_OF_YEAR=").append(this.get(3)).append(",WEEK_OF_MONTH=").append(this.get(4)).append(",DAY_OF_MONTH=").append(this.get(5)).append(",DAY_OF_YEAR=").append(this.get(6)).append(",DAY_OF_WEEK=").append(this.get(7)).append(",DAY_OF_WEEK_IN_MONTH=").append(this.get(8)).append(",AM_PM=").append(this.get(9)).append(",HOUR=").append(this.get(10)).append(",HOUR_OF_DAY=").append(this.get(11)).append(",MINUTE=").append(this.get(12)).append(",SECOND=").append(this.get(13)).append(",MILLISECOND=").append(this.get(14)).append(",ZONE_OFFSET=").append(this.get(15)).append(",DST_OFFSET=").append(this.get(16)).append(']').toString();
    }
}

