/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.Serializable;
import java.util.AbstractList;
import java.util.AbstractListIterator;
import java.util.AbstractMap;
import java.util.AbstractSequentialList;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Random;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;

/*
 * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Collections {
    public static final Set EMPTY_SET = new EmptySet();
    public static final List EMPTY_LIST = new EmptyList();
    public static final Map EMPTY_MAP = new EmptyMap();
    private static final Comparator REVERSE_COMPARATOR = new 1();

    private Collections() {
    }

    public static void sort(List list) {
        Collections.sort(list, Arrays.DEFAULT_COMPARATOR);
    }

    public static void sort(List list, Comparator comparator) {
        Object[] objectArray = list.toArray();
        Arrays.sort(objectArray, comparator);
        int n = objectArray.length - 1;
        while (n >= 0) {
            list.set(n, objectArray[n]);
            --n;
        }
    }

    public static int binarySearch(List list, Object object) {
        return Collections.binarySearch(list, object, Arrays.DEFAULT_COMPARATOR);
    }

    public static int binarySearch(List list, Object object, Comparator comparator) {
        if (list instanceof AbstractSequentialList) {
            Iterator iterator = list.iterator();
            int n = 0;
            while (iterator.hasNext()) {
                if (comparator.compare(iterator.next(), object) == 0) {
                    return n;
                }
                ++n;
            }
            return ~n;
        }
        return Arrays.binarySearch(list.toArray(), object, comparator);
    }

    public static void reverse(List list) {
        ListIterator listIterator = list.listIterator(0);
        ListIterator listIterator2 = list.listIterator(list.size());
        int n = list.size() / 2;
        while (n > 0) {
            Object object = listIterator.next();
            Object object2 = listIterator2.previous();
            listIterator.set(object2);
            listIterator2.set(object);
            --n;
        }
    }

    public static void shuffle(List list) {
        Collections.shuffle(list, new Random());
    }

    public static void shuffle(List list, Random random) {
        ListIterator listIterator = list.listIterator(list.size());
        int n = list.size() - 1;
        while (n > 1) {
            int n2 = random.nextInt(n + 1);
            Object object = listIterator.previous();
            if (n2 != n) {
                Object object2 = list.get(n2);
                list.set(n2, object);
                list.set(n, object2);
            }
            --n;
        }
    }

    public static void fill(List list, Object object) {
        ListIterator listIterator = list.listIterator();
        while (listIterator.hasNext()) {
            listIterator.next();
            listIterator.set(object);
        }
    }

    public static void copy(List list, List list2) {
        if (list.size() < list2.size()) {
            throw new IndexOutOfBoundsException();
        }
        ListIterator listIterator = list.listIterator();
        ListIterator listIterator2 = list2.listIterator();
        while (listIterator2.hasNext()) {
            listIterator.next();
            listIterator.set(listIterator2.next());
        }
    }

    public static ArrayList list(Enumeration enumeration) {
        ArrayList arrayList = new ArrayList();
        while (enumeration.hasMoreElements()) {
            arrayList.add(enumeration.nextElement());
        }
        return arrayList;
    }

    public static Object min(Collection collection) {
        return Collections.min(collection, Arrays.DEFAULT_COMPARATOR);
    }

    public static Object min(Collection collection, Comparator comparator) {
        if (collection.size() == 0) {
            throw new NoSuchElementException();
        }
        Iterator iterator = collection.iterator();
        Object object = iterator.next();
        while (iterator.hasNext()) {
            Object object2 = iterator.next();
            if (comparator.compare(object2, object) >= 0) continue;
            object = object2;
        }
        return object;
    }

    public static Object max(Collection collection) {
        return Collections.max(collection, Arrays.DEFAULT_COMPARATOR);
    }

    public static Object max(Collection collection, Comparator comparator) {
        if (collection.size() == 0) {
            throw new NoSuchElementException();
        }
        Iterator iterator = collection.iterator();
        Object object = iterator.next();
        while (iterator.hasNext()) {
            Object object2 = iterator.next();
            if (comparator.compare(object2, object) <= 0) continue;
            object = object2;
        }
        return object;
    }

    public static Collection unmodifiableCollection(Collection collection) {
        return new UMCollection(collection);
    }

    public static Set unmodifiableSet(Set set) {
        return new UMSet(set);
    }

    public static SortedSet unmodifiableSortedSet(SortedSet sortedSet) {
        return new UMSortedSet(sortedSet);
    }

    public static List unmodifiableList(List list) {
        return new UMList(list);
    }

    public static Map unmodifiableMap(Map map) {
        return new UMMap(map);
    }

    public static SortedMap unmodifiableSortedMap(SortedMap sortedMap) {
        return new UMSortedMap(sortedMap);
    }

    public static Collection synchronizedCollection(Collection collection) {
        return new SyncCollection(collection);
    }

    public static Set synchronizedSet(Set set) {
        return new SyncSet(set);
    }

    public static SortedSet synchronizedSortedSet(SortedSet sortedSet) {
        return new SyncSortedSet(sortedSet);
    }

    public static List synchronizedList(List list) {
        return new SyncList(list);
    }

    public static Map synchronizedMap(Map map) {
        return new SyncMap(map);
    }

    public static SortedMap synchronizedSortedMap(SortedMap sortedMap) {
        return new SyncSortedMap(sortedMap);
    }

    public static Set singleton(Object object) {
        return new 3(object);
    }

    public static List singletonList(Object object) {
        return new CopyList(1, object);
    }

    public static Map singletonMap(Object object, Object object2) {
        HashMap hashMap = new HashMap(1);
        hashMap.put(object, object2);
        return Collections.unmodifiableMap(hashMap);
    }

    public static List nCopies(int n, Object object) {
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        if (n == 0) {
            return EMPTY_LIST;
        }
        return new CopyList(n, object);
    }

    public static Comparator reverseOrder() {
        return REVERSE_COMPARATOR;
    }

    public static Enumeration enumeration(Collection collection) {
        return new 2(collection);
    }

    /*
     * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class EmptySet
    extends AbstractSet
    implements Serializable {
        @Override
        public int size() {
            return 0;
        }

        @Override
        public Iterator iterator() {
            return new 1();
        }

        private EmptySet() {
        }

        /*
         * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
         */
        final class 1
        implements Iterator {
            @Override
            public boolean hasNext() {
                return false;
            }

            @Override
            public Object next() {
                throw new NoSuchElementException();
            }

            @Override
            public void remove() {
                throw new IllegalStateException();
            }
        }
    }

    /*
     * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class EmptyList
    extends AbstractList
    implements Serializable {
        @Override
        public int size() {
            return 0;
        }

        @Override
        public Object get(int n) {
            throw new IndexOutOfBoundsException();
        }

        private EmptyList() {
        }
    }

    /*
     * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class EmptyMap
    extends AbstractMap
    implements Serializable {
        @Override
        public Set entrySet() {
            return EMPTY_SET;
        }

        private EmptyMap() {
        }
    }

    /*
     * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CopyList
    extends AbstractList
    implements Serializable {
        private final Object o;
        private final int num;

        CopyList(int n, Object object) {
            this.num = n;
            this.o = object;
        }

        @Override
        public int size() {
            return this.num;
        }

        @Override
        public Object get(int n) {
            if (n < 0 || n >= this.num) {
                throw new IndexOutOfBoundsException();
            }
            return this.o;
        }

        @Override
        public int indexOf(Object object) {
            if (!(this.o != null ? !this.o.equals(object) : object != null)) {
                return 0;
            }
            return -1;
        }

        @Override
        public int lastIndexOf(Object object) {
            if (!(this.o != null ? !this.o.equals(object) : object != null)) {
                return this.num - 1;
            }
            return -1;
        }

        @Override
        public ListIterator listIterator(int n) {
            if (n < 0 || n > this.num) {
                throw new IndexOutOfBoundsException();
            }
            return new AbstractListIterator(this, n);
        }

        @Override
        public List subList(int n, int n2) {
            if (n < 0 || n2 > this.num) {
                throw new IndexOutOfBoundsException();
            }
            if (n > n2) {
                throw new IllegalArgumentException();
            }
            return Collections.nCopies(n2 - n, this.o);
        }
    }

    /*
     * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SyncCollection
    implements Collection,
    Serializable {
        protected final Collection c;

        SyncCollection(Collection collection) {
            this.c = collection;
        }

        @Override
        public synchronized int size() {
            return this.c.size();
        }

        @Override
        public synchronized boolean isEmpty() {
            return this.c.isEmpty();
        }

        @Override
        public synchronized boolean contains(Object object) {
            return this.c.contains(object);
        }

        @Override
        public synchronized Iterator iterator() {
            return this.c.iterator();
        }

        @Override
        public synchronized Object[] toArray() {
            return this.c.toArray();
        }

        @Override
        public synchronized Object[] toArray(Object[] objectArray) {
            return this.c.toArray(objectArray);
        }

        @Override
        public synchronized boolean add(Object object) {
            return this.c.add(object);
        }

        @Override
        public synchronized boolean remove(Object object) {
            return this.c.remove(object);
        }

        @Override
        public synchronized boolean containsAll(Collection collection) {
            return this.c.containsAll(collection);
        }

        @Override
        public synchronized boolean addAll(Collection collection) {
            return this.c.addAll(collection);
        }

        @Override
        public synchronized boolean removeAll(Collection collection) {
            return this.c.removeAll(collection);
        }

        @Override
        public synchronized boolean retainAll(Collection collection) {
            return this.c.retainAll(collection);
        }

        @Override
        public synchronized void clear() {
            this.c.clear();
        }

        @Override
        public synchronized boolean equals(Object object) {
            return this.c.equals(object);
        }

        @Override
        public synchronized int hashCode() {
            return this.c.hashCode();
        }
    }

    /*
     * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SyncSet
    extends SyncCollection
    implements Set {
        SyncSet(Set set) {
            super(set);
        }
    }

    /*
     * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SyncSortedSet
    extends SyncSet
    implements SortedSet {
        SyncSortedSet(SortedSet sortedSet) {
            super(sortedSet);
        }

        @Override
        public synchronized Comparator comparator() {
            return ((SortedSet)this.c).comparator();
        }

        @Override
        public synchronized SortedSet subSet(Object object, Object object2) {
            return ((SortedSet)this.c).subSet(object, object2);
        }

        @Override
        public synchronized SortedSet headSet(Object object) {
            return ((SortedSet)this.c).headSet(object);
        }

        @Override
        public synchronized SortedSet tailSet(Object object) {
            return ((SortedSet)this.c).tailSet(object);
        }

        @Override
        public synchronized Object first() {
            return ((SortedSet)this.c).first();
        }

        @Override
        public synchronized Object last() {
            return ((SortedSet)this.c).last();
        }
    }

    /*
     * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SyncList
    extends SyncCollection
    implements List {
        SyncList(List list) {
            super(list);
        }

        @Override
        public synchronized void add(int n, Object object) {
            ((List)this.c).add(n, object);
        }

        @Override
        public synchronized boolean addAll(int n, Collection collection) {
            return ((List)this.c).addAll(n, collection);
        }

        @Override
        public synchronized Object get(int n) {
            return ((List)this.c).get(n);
        }

        @Override
        public synchronized int indexOf(Object object) {
            return ((List)this.c).indexOf(object);
        }

        @Override
        public synchronized int lastIndexOf(Object object) {
            return ((List)this.c).lastIndexOf(object);
        }

        @Override
        public synchronized ListIterator listIterator() {
            return ((List)this.c).listIterator();
        }

        @Override
        public synchronized ListIterator listIterator(int n) {
            return ((List)this.c).listIterator(n);
        }

        @Override
        public synchronized Object remove(int n) {
            return ((List)this.c).remove(n);
        }

        @Override
        public synchronized Object set(int n, Object object) {
            return ((List)this.c).set(n, object);
        }

        @Override
        public synchronized List subList(int n, int n2) {
            return ((List)this.c).subList(n, n2);
        }
    }

    /*
     * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SyncMap
    implements Map,
    Serializable {
        protected final Map m;

        SyncMap(Map map) {
            this.m = map;
        }

        @Override
        public synchronized int size() {
            return this.m.size();
        }

        @Override
        public synchronized boolean isEmpty() {
            return this.m.isEmpty();
        }

        @Override
        public synchronized boolean containsKey(Object object) {
            return this.m.containsKey(object);
        }

        @Override
        public synchronized boolean containsValue(Object object) {
            return this.m.containsValue(object);
        }

        @Override
        public synchronized Object get(Object object) {
            return this.m.get(object);
        }

        @Override
        public synchronized Object put(Object object, Object object2) {
            return this.m.put(object, object2);
        }

        @Override
        public synchronized void putAll(Map map) {
            this.m.putAll(map);
        }

        @Override
        public synchronized void clear() {
            this.m.clear();
        }

        @Override
        public synchronized Set keySet() {
            return this.m.keySet();
        }

        @Override
        public synchronized Set entrySet() {
            return this.m.entrySet();
        }

        @Override
        public synchronized Collection values() {
            return this.m.values();
        }

        @Override
        public synchronized boolean equals(Object object) {
            return this.m.equals(object);
        }

        @Override
        public synchronized int hashCode() {
            return this.m.hashCode();
        }

        @Override
        public synchronized Object remove(Object object) {
            return this.m.remove(object);
        }
    }

    /*
     * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SyncSortedMap
    extends SyncMap
    implements SortedMap {
        SyncSortedMap(SortedMap sortedMap) {
            super(sortedMap);
        }

        @Override
        public synchronized Comparator comparator() {
            return ((SortedMap)this.m).comparator();
        }

        @Override
        public synchronized SortedMap subMap(Object object, Object object2) {
            return ((SortedMap)this.m).subMap(object, object2);
        }

        @Override
        public synchronized SortedMap headMap(Object object) {
            return ((SortedMap)this.m).headMap(object);
        }

        @Override
        public synchronized SortedMap tailMap(Object object) {
            return ((SortedMap)this.m).tailMap(object);
        }

        @Override
        public synchronized Object firstKey() {
            return ((SortedMap)this.m).firstKey();
        }

        @Override
        public synchronized Object lastKey() {
            return ((SortedMap)this.m).lastKey();
        }
    }

    /*
     * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class UMCollection
    implements Collection,
    Serializable {
        protected final Collection c;

        UMCollection(Collection collection) {
            this.c = collection;
        }

        @Override
        public int size() {
            return this.c.size();
        }

        @Override
        public boolean isEmpty() {
            return this.c.isEmpty();
        }

        @Override
        public boolean contains(Object object) {
            return this.c.contains(object);
        }

        @Override
        public Iterator iterator() {
            return new UMIterator(this.c.iterator());
        }

        @Override
        public Object[] toArray() {
            return this.c.toArray();
        }

        @Override
        public Object[] toArray(Object[] objectArray) {
            return this.c.toArray(objectArray);
        }

        @Override
        public boolean add(Object object) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean remove(Object object) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean containsAll(Collection collection) {
            return this.c.containsAll(collection);
        }

        @Override
        public boolean addAll(Collection collection) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean removeAll(Collection collection) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean retainAll(Collection collection) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean equals(Object object) {
            return this.c.equals(object);
        }

        @Override
        public int hashCode() {
            return this.c.hashCode();
        }
    }

    /*
     * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class UMSet
    extends UMCollection
    implements Set {
        UMSet(Set set) {
            super(set);
        }
    }

    /*
     * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class UMSortedSet
    extends UMSet
    implements SortedSet {
        UMSortedSet(SortedSet sortedSet) {
            super(sortedSet);
        }

        @Override
        public Comparator comparator() {
            return ((SortedSet)this.c).comparator();
        }

        @Override
        public SortedSet subSet(Object object, Object object2) {
            return new UMSortedSet(((SortedSet)this.c).subSet(object, object2));
        }

        @Override
        public SortedSet headSet(Object object) {
            return new UMSortedSet(((SortedSet)this.c).headSet(object));
        }

        @Override
        public SortedSet tailSet(Object object) {
            return new UMSortedSet(((SortedSet)this.c).tailSet(object));
        }

        @Override
        public Object first() {
            return ((SortedSet)this.c).first();
        }

        @Override
        public Object last() {
            return ((SortedSet)this.c).last();
        }
    }

    /*
     * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class UMList
    extends UMCollection
    implements List {
        UMList(List list) {
            super(list);
        }

        @Override
        public void add(int n, Object object) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(int n, Collection collection) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Object get(int n) {
            return ((List)this.c).get(n);
        }

        @Override
        public int indexOf(Object object) {
            return ((List)this.c).indexOf(object);
        }

        @Override
        public int lastIndexOf(Object object) {
            return ((List)this.c).lastIndexOf(object);
        }

        @Override
        public ListIterator listIterator() {
            return new UMListIterator(((List)this.c).listIterator());
        }

        @Override
        public ListIterator listIterator(int n) {
            return new UMListIterator(((List)this.c).listIterator(n));
        }

        @Override
        public Object remove(int n) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Object set(int n, Object object) {
            throw new UnsupportedOperationException();
        }

        @Override
        public List subList(int n, int n2) {
            return new UMList(((List)this.c).subList(n, n2));
        }
    }

    /*
     * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class UMMap
    implements Map,
    Serializable {
        protected final Map m;

        UMMap(Map map) {
            this.m = map;
        }

        @Override
        public int size() {
            return this.m.size();
        }

        @Override
        public boolean isEmpty() {
            return this.m.isEmpty();
        }

        @Override
        public boolean containsKey(Object object) {
            return this.m.containsKey(object);
        }

        @Override
        public boolean containsValue(Object object) {
            return this.m.containsValue(object);
        }

        @Override
        public Object get(Object object) {
            return this.m.get(object);
        }

        @Override
        public Object put(Object object, Object object2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void putAll(Map map) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Set keySet() {
            return new UMSet(this.m.keySet());
        }

        @Override
        public Set entrySet() {
            return new UMSet(this.m.entrySet());
        }

        @Override
        public Collection values() {
            return new UMCollection(this.m.values());
        }

        @Override
        public boolean equals(Object object) {
            return this.m.equals(object);
        }

        @Override
        public int hashCode() {
            return this.m.hashCode();
        }

        @Override
        public Object remove(Object object) {
            throw new UnsupportedOperationException();
        }
    }

    /*
     * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class UMSortedMap
    extends UMMap
    implements SortedMap {
        UMSortedMap(SortedMap sortedMap) {
            super(sortedMap);
        }

        @Override
        public Comparator comparator() {
            return ((SortedMap)this.m).comparator();
        }

        @Override
        public SortedMap subMap(Object object, Object object2) {
            return new UMSortedMap(((SortedMap)this.m).subMap(object, object2));
        }

        @Override
        public SortedMap headMap(Object object) {
            return new UMSortedMap(((SortedMap)this.m).headMap(object));
        }

        @Override
        public SortedMap tailMap(Object object) {
            return new UMSortedMap(((SortedMap)this.m).tailMap(object));
        }

        @Override
        public Object firstKey() {
            return ((SortedMap)this.m).firstKey();
        }

        @Override
        public Object lastKey() {
            return ((SortedMap)this.m).lastKey();
        }
    }

    /*
     * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class UMIterator
    implements Iterator {
        protected final Iterator i;

        UMIterator(Iterator iterator) {
            this.i = iterator;
        }

        @Override
        public boolean hasNext() {
            return this.i.hasNext();
        }

        @Override
        public Object next() {
            return this.i.next();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    /*
     * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class UMListIterator
    extends UMIterator
    implements ListIterator {
        UMListIterator(ListIterator listIterator) {
            super(listIterator);
        }

        @Override
        public boolean hasPrevious() {
            return ((ListIterator)this.i).hasPrevious();
        }

        @Override
        public Object previous() {
            return ((ListIterator)this.i).previous();
        }

        @Override
        public int nextIndex() {
            return ((ListIterator)this.i).nextIndex();
        }

        @Override
        public int previousIndex() {
            return ((ListIterator)this.i).previousIndex();
        }

        @Override
        public void set(Object object) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void add(Object object) {
            throw new UnsupportedOperationException();
        }
    }

    /*
     * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class 1
    implements Comparator {
        @Override
        public int compare(Object object, Object object2) {
            return -((Comparable)object).compareTo(object2);
        }
    }

    /*
     * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class 2
    implements Enumeration {
        private final Iterator i;
        private final /* synthetic */ Collection var$c;

        @Override
        public boolean hasMoreElements() {
            return this.i.hasNext();
        }

        @Override
        public Object nextElement() {
            return this.i.next();
        }

        public 2(Collection collection) {
            this.var$c = collection;
            this.Block$();
        }

        private /* synthetic */ void Block$() {
            this.i = this.var$c.iterator();
        }
    }

    /*
     * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class 3
    extends AbstractSet {
        private final /* synthetic */ Object var$o;

        @Override
        public int size() {
            return 1;
        }

        @Override
        public Iterator iterator() {
            return Collections.nCopies(1, this.var$o).iterator();
        }

        public 3(Object object) {
            this.var$o = object;
        }
    }
}

