/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.SimpleTimeZone;
import java.util.TimeZone;

/*
 * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GregorianCalendar
extends Calendar {
    private static final long serialVersionUID = -8125100834729963327L;
    public static final int BC = 0;
    public static final int AD = 1;
    private static final long MILLISECSPERSEC = 1000L;
    private static final long SECSPERMIN = 60L;
    private static final long MILLISECSPERMIN = 60000L;
    private static final long MINSPERHOUR = 60L;
    private static final long MILLISECSPERHOUR = 3600000L;
    private static final long HOURSPERDAY = 24L;
    private static final long MILLISECSPERDAY = 86400000L;
    private static final int DAYSPERWEEK = 7;
    private static final int MONTHSPERYEAR = 12;
    private static final int EPOCH_WDAY = 4;
    private static final int EPOCH_YEAR = 1970;
    private static final SimpleTimeZone simple_zone = new SimpleTimeZone(0, "_temp");
    private static final Date stdDateChange = new Date(-12219292800000L);
    private Date dateChange;
    private int dateChangeYear;

    public GregorianCalendar() {
        this(TimeZone.getDefault(), Locale.getDefault());
    }

    public GregorianCalendar(Locale locale2) {
        this(TimeZone.getDefault(), locale2);
    }

    public GregorianCalendar(TimeZone timeZone) {
        this(timeZone, Locale.getDefault());
    }

    public GregorianCalendar(TimeZone timeZone, Locale locale2) {
        super(timeZone, locale2);
        this.Block$();
        this.setTime(new Date());
    }

    public GregorianCalendar(int n, int n2, int n3) {
        this(n, n2, n3, 0, 0);
    }

    public GregorianCalendar(int n, int n2, int n3, int n4, int n5) {
        this(n, n2, n3, n4, n5, 0);
    }

    public GregorianCalendar(int n, int n2, int n3, int n4, int n5, int n6) {
        this.Block$();
        this.set(n, n2, n3, n4, n5, n6);
    }

    @Override
    public void add(int n, int n2) {
        if (n == 15 || n == 16) {
            throw new IllegalArgumentException(new StringBuffer().append("bad field: ").append(n).toString());
        }
        if (!this.isSet(n)) {
            this.computeFields();
        }
        int n3 = n;
        this.fields[n3] = this.fields[n3] + n2;
        this.isTimeSet = false;
        this.computeTime();
        this.computeFields();
    }

    private void checkFields() {
        if (!this.isLenient()) {
            int n = 0;
            while (n < 17) {
                int n2 = this.internalGet(n);
                if (n2 < this.getMinimum(n) || n2 > this.getMaximum(n)) {
                    throw new IllegalArgumentException(new StringBuffer().append("value ").append(n2).append(" out of range for field ").append(n).append(" [ ").append(this.getMinimum(n)).append(", ").append(this.getMaximum(n)).append(" ]").toString());
                }
                ++n;
            }
        }
    }

    private void completeCounter(GregorianCalendar gregorianCalendar) {
        gregorianCalendar.setTimeZone(simple_zone);
        gregorianCalendar.complete();
    }

    private long computeDateTime() {
        this.checkFields();
        long l = 0L;
        boolean bl = (this.isSet(1) && this.internalGet(1) < 1970) ^ true;
        if (this.isSet(1)) {
            l += this.computeDateTimeForYear(bl);
        }
        if (this.isSet(2)) {
            l += this.computeDateTimeForMonth(bl);
            if (this.isSet(5)) {
                l += this.computeDateTimeForDayOfMonth(bl);
            } else if (this.isSet(4) && this.isSet(7)) {
                l += this.computeDateTimeForWeekOfMonthAndDayOfWeek(bl);
            } else if (this.isSet(8) && this.isSet(7)) {
                l += this.computeDateTimeForDayOfWeekInMonthAndDayOfWeek(bl);
            }
        } else if (this.isSet(6)) {
            l += this.computeDateTimeForDayOfYear(bl);
        } else if (this.isSet(7) && this.isSet(3)) {
            l += this.computeDateTimeForWeekOfYearAndDayOfWeek(bl);
        }
        l *= 24L;
        if (this.isSet(11)) {
            l += this.computeDateTimeForHourOfDay(bl);
        } else if (this.isSet(9) && this.isSet(10)) {
            l += this.computeDateTimeForAMPMAndHour(bl);
        }
        l *= 60L;
        if (this.isSet(12)) {
            l += this.computeDateTimeForMinute(bl);
        }
        l *= 60L;
        if (this.isSet(13)) {
            l += this.computeDateTimeForSecond(bl);
        }
        l *= 1000L;
        if (this.isSet(14)) {
            l += this.computeDateTimeForMillisecond(bl);
        }
        if (this.isSet(15)) {
            l += this.computeDateTimeForZoneOffset(bl);
        }
        return l;
    }

    private long computeDateTimeForAMPMAndHour(boolean bl) {
        long l = 0L;
        if (bl) {
            l += (long)this.internalGet(10);
            if (this.internalGet(9) == 1) {
                l += 12L;
            }
        } else {
            l -= (long)(this.getMaximum(10) - this.internalGet(10));
            if (this.internalGet(9) == 0) {
                l -= 12L;
            }
        }
        return l;
    }

    private long computeDateTimeForDayOfMonth(boolean bl) {
        if (bl) {
            return this.internalGet(5) - 1;
        }
        return this.internalGet(5) - this.getDaysInMonth(this.internalGet(2), this.internalGet(1));
    }

    private long computeDateTimeForDayOfWeekInMonthAndDayOfWeek(boolean bl) {
        GregorianCalendar gregorianCalendar = this.getMonthCounter(bl);
        while (gregorianCalendar.get(8) != this.internalGet(8) || gregorianCalendar.get(7) != this.internalGet(7)) {
            gregorianCalendar.roll(6, bl);
        }
        return bl ? gregorianCalendar.get(5) - 1 : gregorianCalendar.get(5) - this.getDaysInMonth(this.internalGet(2), this.internalGet(1));
    }

    private long computeDateTimeForDayOfYear(boolean bl) {
        if (bl) {
            return this.internalGet(5);
        }
        return this.internalGet(6) - this.getDaysInYear(this.internalGet(1));
    }

    private long computeDateTimeForHourOfDay(boolean bl) {
        if (bl) {
            return this.internalGet(11);
        }
        return this.internalGet(11) - this.getMaximum(11);
    }

    private long computeDateTimeForMillisecond(boolean bl) {
        if (bl) {
            return this.internalGet(14);
        }
        return this.internalGet(14) - this.getMaximum(14);
    }

    private long computeDateTimeForMinute(boolean bl) {
        if (bl) {
            return this.internalGet(12);
        }
        return this.internalGet(12) - this.getMaximum(12);
    }

    private long computeDateTimeForMonth(boolean bl) {
        long l = 0L;
        int n = this.internalGet(2);
        int n2 = this.internalGet(1);
        int n3 = Math.abs(n) / 12;
        if ((n %= 12) < 0) {
            n += 12;
        }
        if (bl) {
            l += this.computeDaysBetweenYears(n2, n2 + n3);
            n2 += n3;
            int n4 = 0;
            while (n4 < n) {
                l += (long)this.getDaysInMonth(n4, n2);
                ++n4;
            }
        } else {
            l -= this.computeDaysBetweenYears(n2 - n3, n2);
            n2 -= n3;
            int n5 = 11;
            while (n5 > n) {
                l -= (long)this.getDaysInMonth(n5, n2);
                --n5;
            }
        }
        return l;
    }

    private long computeDateTimeForSecond(boolean bl) {
        if (bl) {
            return this.internalGet(13);
        }
        return this.internalGet(13) - this.getMaximum(13);
    }

    private long computeDateTimeForWeekOfMonthAndDayOfWeek(boolean bl) {
        GregorianCalendar gregorianCalendar = this.getMonthCounter(bl);
        while (gregorianCalendar.get(4) != this.internalGet(4) || gregorianCalendar.get(7) != this.internalGet(7)) {
            gregorianCalendar.roll(6, bl);
        }
        return bl ? gregorianCalendar.get(5) - 1 : gregorianCalendar.get(5) - this.getDaysInMonth(this.internalGet(2), this.internalGet(1));
    }

    private long computeDateTimeForWeekOfYearAndDayOfWeek(boolean bl) {
        GregorianCalendar gregorianCalendar = this.getYearCounter(bl);
        while (gregorianCalendar.get(3) != this.internalGet(3) || gregorianCalendar.get(7) != this.internalGet(7)) {
            gregorianCalendar.roll(6, bl);
        }
        return bl ? gregorianCalendar.get(6) : gregorianCalendar.get(6) - this.getDaysInYear(this.internalGet(1));
    }

    private long computeDateTimeForYear(boolean bl) {
        long l = 0L;
        int n = this.internalGet(1);
        l = bl ? (l += this.computeDaysBetweenYears(1970, n)) : (l -= this.computeDaysBetweenYears(n + 1, 1970));
        return l;
    }

    private long computeDateTimeForZoneOffset(boolean bl) {
        if (bl) {
            return -this.internalGet(15);
        }
        return this.internalGet(15);
    }

    private long computeDaysBetweenYears(int n, int n2) {
        long l = 0L;
        int n3 = n;
        while (n3 < n2) {
            l += (long)this.getDaysInYear(n3);
            ++n3;
        }
        return l;
    }

    @Override
    protected void computeFields() {
        if (this.areFieldsSet) {
            return;
        }
        if (!this.isTimeSet) {
            throw new IllegalArgumentException();
        }
        long l = this.getTimeZone().getRawOffset();
        this.computeFields(this.time + l);
        long l2 = this.getTimeZone().getOffset(this.internalGet(0), this.internalGet(1), this.internalGet(2), this.internalGet(5), this.internalGet(7), this.internalGet(14));
        if (l2 != l) {
            this.computeFields(this.time + l2);
            this.internalSet(15, (int)l2);
        } else {
            this.internalSet(15, (int)l);
        }
        this.areFieldsSet = true;
    }

    private void computeFields(long l) {
        long l2;
        long l3;
        int n;
        boolean bl;
        boolean bl2 = bl = l >= 0L;
        if (l < 0L) {
            l = -l;
        }
        long l4 = l;
        long l5 = l4 / 86400000L;
        if (!bl && l4 % 86400000L / 1000L != 0L) {
            ++l5;
        }
        int n2 = (int)((l4 %= 86400000L) / 3600000L);
        int n3 = (int)((l4 %= 3600000L) / 60000L);
        int n4 = (int)((l4 %= 60000L) / 1000L);
        int n5 = (int)(l4 % 1000L);
        int n6 = n = bl ? (int)((4L + l5) % 7L + 1L) : (int)((4L - l5) % 7L + 1L);
        if (!bl && this.dateChangeYear < 1970 && this.isBeforeGregorianChange(-l)) {
            n = (n - 11) % 7 + 7;
        }
        if (n == 0) {
            n = 7;
        }
        int n7 = 1970;
        long l6 = 0L;
        while (true) {
            if (l5 < (l3 = (long)this.getDaysInYear(n7))) {
                if (bl || l5 == 0L) break;
                l6 += (long)this.getDaysInYear(--n7);
                break;
            }
            l5 -= l3;
            if (bl) {
                l6 += l3;
                ++n7;
                continue;
            }
            l6 -= l3;
            --n7;
        }
        l3 = l6;
        int n8 = bl ? 0 : 11;
        int n9 = (int)l5;
        while (l5 >= (l2 = (long)this.getDaysInMonth(n8, n7))) {
            if (bl) {
                l3 += l2;
                ++n8;
            } else {
                l3 -= l2;
                --n8;
            }
            l5 -= l2;
        }
        if (n7 < 1) {
            this.internalSet(0, 0);
        } else {
            this.internalSet(0, 1);
        }
        this.internalSet(1, n7);
        this.internalSet(2, n8);
        if (bl) {
            this.internalSet(5, (int)(1L + l5));
            this.internalSet(6, 1 + n9);
        } else {
            this.internalSet(6, this.getDaysInYear(n7) - n9);
            this.internalSet(5, (int)((long)this.getDaysInMonth(n8, n7) - l5));
        }
        this.internalSet(7, n);
        if (n2 < 12) {
            if (bl || n2 == 0) {
                this.internalSet(9, 0);
                this.internalSet(10, n2);
            } else {
                this.internalSet(9, 1);
                this.internalSet(10, this.getMaximum(10) - n2);
            }
        } else if (bl) {
            this.internalSet(9, 1);
            this.internalSet(10, n2 - 12);
        } else {
            this.internalSet(9, 0);
            this.internalSet(10, this.getMaximum(11) - n2);
        }
        if (bl) {
            this.internalSet(11, n2);
            this.internalSet(12, n3);
            this.internalSet(13, n4);
            this.internalSet(14, n5);
        } else {
            this.internalSet(11, n2 == 0 ? 0 : this.getMaximum(11) - n2);
            this.internalSet(12, n3 == 0 ? 0 : this.getMaximum(12) - n3);
            this.internalSet(13, n4 == 0 ? 0 : this.getMaximum(13) - n4);
            this.internalSet(14, n5 == 0 ? 0 : this.getMaximum(14) - n5);
        }
        int n10 = (int)((4L + l6) % 7L);
        int n11 = (n10 + this.internalGet(6)) / 7 + 1;
        this.internalSet(3, n11);
        this.internalSet(8, (1 + this.internalGet(5)) / 7);
        int n12 = (int)((4L + l3) % 7L);
        int n13 = (n12 + this.internalGet(5)) / 7 + 1;
        this.internalSet(4, n13);
    }

    @Override
    protected void computeTime() {
        if (this.isTimeSet) {
            return;
        }
        long l = 0L;
        if (!this.isSet(0)) {
            this.set(0, 1);
        }
        if (!this.isSet(15)) {
            l = this.getTimeZone().getOffset(this.internalGet(0), this.internalGet(1), this.internalGet(2), this.internalGet(5), this.internalGet(7), this.internalGet(14));
        }
        this.time = this.computeDateTime() - l;
        this.isTimeSet = true;
    }

    @Override
    public boolean equals(Object object) {
        return object instanceof GregorianCalendar && super.equals(object);
    }

    private int getDaysInMonth(int n, int n2) {
        switch (n) {
            case 1: {
                if (this.isLeapYear(n2)) {
                    return 29;
                }
                return 28;
            }
            case 3: 
            case 5: 
            case 8: 
            case 10: {
                return 30;
            }
        }
        return 31;
    }

    private int getDaysInYear(int n) {
        if (this.isLeapYear(n)) {
            return 366;
        }
        return 365;
    }

    @Override
    public int getGreatestMinimum(int n) {
        return this.getMinimum(n);
    }

    public final Date getGregorianChange() {
        if (this.dateChange == null) {
            return stdDateChange;
        }
        return this.dateChange;
    }

    @Override
    public int getLeastMaximum(int n) {
        switch (n) {
            case 5: {
                return 28;
            }
            case 4: 
            case 8: {
                return 4;
            }
            case 6: {
                return 365;
            }
            case 3: {
                return 52;
            }
            case 1: {
                return 292269054;
            }
        }
        return this.getMaximum(n);
    }

    @Override
    public int getMaximum(int n) {
        switch (n) {
            case 0: 
            case 9: {
                return 1;
            }
            case 1: {
                return 292278994;
            }
            case 2: {
                return 11;
            }
            case 3: {
                return 53;
            }
            case 4: 
            case 8: {
                return 6;
            }
            case 5: {
                return 31;
            }
            case 6: {
                return 366;
            }
            case 7: {
                return 7;
            }
            case 10: {
                return 11;
            }
            case 11: {
                return 23;
            }
            case 12: 
            case 13: {
                return 59;
            }
            case 14: {
                return 999;
            }
            case 15: {
                return 43200000;
            }
        }
        return 0;
    }

    @Override
    public int getMinimum(int n) {
        switch (n) {
            case 1: 
            case 3: 
            case 5: 
            case 6: 
            case 7: {
                return 1;
            }
            case 2: {
                return 0;
            }
            case 8: {
                return -1;
            }
            case 15: {
                return -43200000;
            }
        }
        return 0;
    }

    private GregorianCalendar getMonthCounter(boolean bl) {
        GregorianCalendar gregorianCalendar = new GregorianCalendar(this.internalGet(1), this.internalGet(2), bl ? 1 : this.getDaysInMonth(this.internalGet(2), this.internalGet(1)));
        this.completeCounter(gregorianCalendar);
        return gregorianCalendar;
    }

    private GregorianCalendar getYearCounter(boolean bl) {
        GregorianCalendar gregorianCalendar = new GregorianCalendar(this.internalGet(1), bl ? 0 : 11, bl ? 1 : 31);
        this.completeCounter(gregorianCalendar);
        return gregorianCalendar;
    }

    @Override
    public synchronized int hashCode() {
        return this.getFirstDayOfWeek() ^ this.getMinimalDaysInFirstWeek();
    }

    private boolean isBeforeGregorianChange(long l) {
        return l < this.dateChange.getTime();
    }

    public boolean isLeapYear(int n) {
        if (n > this.dateChangeYear) {
            if (n % 400 == 0) {
                return true;
            }
            if (n % 100 == 0) {
                return false;
            }
            return n % 4 == 0;
        }
        return n % 4 == 0;
    }

    @Override
    public void roll(int n, boolean bl) {
        if (n == 15 || n == 16) {
            throw new IllegalArgumentException(new StringBuffer().append("bad field: ").append(n).toString());
        }
        if (!this.isSet(n)) {
            this.computeFields();
        }
        if (bl) {
            if (this.internalGet(n) == this.getMaximum(n)) {
                this.set(n, this.getMinimum(n));
            } else {
                this.set(n, this.internalGet(n) + 1);
            }
        } else if (this.internalGet(n) == this.getMinimum(n)) {
            this.set(n, this.getMaximum(n));
        } else {
            this.set(n, this.internalGet(n) - 1);
        }
        this.computeTime();
        this.computeFields();
    }

    public void setGregorianChange(Date date) {
        this.dateChange = date;
        this.dateChangeYear = date.getYear();
    }

    private /* synthetic */ void Block$() {
        this.dateChange = stdDateChange;
        this.dateChangeYear = 1582;
    }
}

