/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamField;
import java.security.BasicPermission;
import java.security.Permission;
import java.security.PermissionCollection;
import java.util.PropertyPermissionCollection;

/*
 * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PropertyPermission
extends BasicPermission {
    private static final ObjectStreamField[] serialPersistentFields = new ObjectStreamField[]{new ObjectStreamField("action", Class.forName("java.lang.String"))};
    private static final long serialVersionUID = 885438825399942851L;
    private static final int READ = 1;
    private static final int WRITE = 2;
    transient int actions;
    private static final String[] actionStrings = new String[]{"", "read", "write", "read,write"};

    public PropertyPermission(String string, String string2) {
        super(string);
        if (string2 == null) {
            throw new IllegalArgumentException();
        }
        this.setActions(string2.toLowerCase());
    }

    private void setActions(String string) {
        if ("read".equals(string)) {
            this.actions = 1;
            return;
        }
        if ("write".equals(string)) {
            this.actions = 2;
            return;
        }
        if ("read,write".equals(string) || "write,read".equals(string)) {
            this.actions = 3;
            return;
        }
        throw new IllegalArgumentException(new StringBuffer().append("illegal action ").append(string).toString());
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        ObjectInputStream.GetField getField = objectInputStream.readFields();
        this.setActions((String)getField.get("actions", null));
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        ObjectOutputStream.PutField putField = objectOutputStream.putFields();
        putField.put("actions", this.getActions());
        objectOutputStream.writeFields();
    }

    @Override
    public boolean implies(Permission permission) {
        if (super.implies(permission)) {
            PropertyPermission propertyPermission = (PropertyPermission)permission;
            return (propertyPermission.actions & ~this.actions) == 0;
        }
        return false;
    }

    @Override
    public boolean equals(Object object) {
        return super.equals(object) && this.actions == ((PropertyPermission)object).actions;
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public String getActions() {
        return actionStrings[this.actions];
    }

    public PermissionCollection newPermissionCollection() {
        return new PropertyPermissionCollection();
    }
}

