/*
 * Decompiled with CFR 0.152.
 */
package java.util.logging;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;
import java.util.logging.StreamHandler;

/*
 * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileHandler
extends StreamHandler {
    private final int limit;
    private final int count;
    private final String pattern;
    private final boolean append;

    public FileHandler() throws IOException, SecurityException {
        this(null, LogManager.getIntProperty("java.util.logging.FileHandler.limit", 0), LogManager.getIntProperty("java.util.logging.FileHandler.count", 1), LogManager.getBooleanProperty("java.util.logging.FileHandler.append", false));
    }

    public FileHandler(String string, boolean bl) throws IOException, SecurityException {
        this(string, 0, 1, bl);
    }

    public FileHandler(String string, int n, int n2) throws IOException, SecurityException {
        this(string, n, n2, LogManager.getBooleanProperty("java.util.logging.FileHandler.append", false));
    }

    public FileHandler(String string, int n, int n2, boolean bl) throws IOException, SecurityException {
        super(FileHandler.createFileStream(string, n, n2, bl, 0), "java.util.logging.FileHandler", Level.ALL, null, Class.forName("java.util.logging.XMLFormatter"));
        if (n < 0 || n2 < 1) {
            throw new IllegalArgumentException();
        }
        this.pattern = string;
        this.limit = n;
        this.count = n2;
        this.append = bl;
    }

    private static OutputStream createFileStream(String string, int n, int n2, boolean bl, int n3) {
        int n4 = 0;
        LogManager.getLogManager().checkAccess();
        if (string == null) {
            string = LogManager.getLogManager().getProperty("java.util.logging.FileHandler.pattern");
        }
        if (string == null) {
            string = "%h/java%u.log";
        }
        while (true) {
            String string2 = FileHandler.replaceFileNameEscapes(string, n3, n4, n2);
            try {
                File file = new File(string2);
                if (file.createNewFile()) {
                    return new FileOutputStream(string2, bl);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            ++n4;
            if (string.indexOf("%u") >= 0) continue;
            string = new StringBuffer().append(string).append(".%u").toString();
        }
    }

    private static String replaceFileNameEscapes(String string, int n, int n2, int n3) {
        StringBuffer stringBuffer = new StringBuffer(string);
        boolean bl = false;
        int n4 = 0;
        do {
            String string2;
            if (stringBuffer.charAt(n4) == '/') {
                string2 = System.getProperty("file.separator");
                stringBuffer.replace(n4, n4 + 1, string2);
                n4 = n4 + string2.length() - 1;
                continue;
            }
            if (stringBuffer.charAt(n4) != '%') continue;
            switch (stringBuffer.charAt(n4 + 1)) {
                case 't': {
                    string2 = System.getProperty("java.io.tmpdir");
                    break;
                }
                case 'h': {
                    string2 = System.getProperty("user.home");
                    break;
                }
                case 'g': {
                    string2 = Integer.toString(n);
                    bl = true;
                    break;
                }
                case 'u': {
                    string2 = Integer.toString(n2);
                    break;
                }
                case '%': {
                    string2 = "%";
                    break;
                }
                default: {
                    string2 = "??";
                }
            }
            stringBuffer.replace(n4, n4 + 2, string2);
            n4 = n4 + string2.length() - 1;
        } while (++n4 < stringBuffer.length() - 1);
        if (!bl && n3 > 1) {
            stringBuffer.append('.');
            stringBuffer.append(n);
        }
        return stringBuffer.toString();
    }

    @Override
    public void publish(LogRecord logRecord) {
        super.publish(logRecord);
    }
}

