/*
 * Decompiled with CFR 0.152.
 */
package java.util.prefs;

import gnu.java.util.prefs.NodeReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.AccessController;
import java.security.Permission;
import java.security.PrivilegedAction;
import java.util.prefs.BackingStoreException;
import java.util.prefs.InvalidPreferencesFormatException;
import java.util.prefs.NodeChangeListener;
import java.util.prefs.PreferenceChangeListener;
import java.util.prefs.PreferencesFactory;

/*
 * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Preferences {
    private static final String defaultFactoryClass = "gnu.java.util.prefs.MemoryBasedPreferencesFactory";
    private static final Permission prefsPermission = new RuntimePermission("preferences");
    private static PreferencesFactory factory;
    public static final int MAX_NAME_LENGTH = 80;
    public static final int MAX_KEY_LENGTH = 80;
    public static final int MAX_VALUE_LENGTH = 8192;

    protected Preferences() {
    }

    public static Preferences systemRoot() throws SecurityException {
        PreferencesFactory preferencesFactory = Preferences.getFactory();
        return preferencesFactory.systemRoot();
    }

    public static Preferences userRoot() throws SecurityException {
        PreferencesFactory preferencesFactory = Preferences.getFactory();
        return preferencesFactory.userRoot();
    }

    private static PreferencesFactory getFactory() throws SecurityException {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(prefsPermission);
        }
        if (factory == null && (factory = (PreferencesFactory)AccessController.doPrivileged(new 1())) == null) {
            try {
                Class clazz = Class.forName(defaultFactoryClass);
                factory = (PreferencesFactory)((Object)clazz);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new RuntimeException("Couldn't load default factory 'gnu.java.util.prefs.MemoryBasedPreferencesFactory'");
            }
        }
        return factory;
    }

    public static Preferences systemNodeForPackage(Object object) throws SecurityException {
        return Preferences.nodeForPackage(object, Preferences.systemRoot());
    }

    public static Preferences userNodeForPackage(Object object) throws SecurityException {
        return Preferences.nodeForPackage(object, Preferences.userRoot());
    }

    private static Preferences nodeForPackage(Object object, Preferences preferences) {
        String string = object.getClass().getName();
        int n = string.lastIndexOf(46);
        String string2 = n == -1 ? "<unnamed>" : string.substring(0, n).replace('.', '/');
        return preferences.node(string2);
    }

    public static void importPreferences(InputStream inputStream) throws InvalidPreferencesFormatException, IOException {
        PreferencesFactory preferencesFactory = Preferences.getFactory();
        NodeReader nodeReader = new NodeReader(inputStream, preferencesFactory);
        nodeReader.importPreferences();
    }

    public abstract String absolutePath();

    public abstract boolean isUserNode();

    public abstract String name();

    public abstract String toString();

    public abstract String[] childrenNames() throws BackingStoreException;

    public abstract Preferences node(String var1);

    public abstract boolean nodeExists(String var1) throws BackingStoreException;

    public abstract Preferences parent();

    public abstract void exportNode(OutputStream var1) throws BackingStoreException, IOException;

    public abstract void exportSubtree(OutputStream var1) throws BackingStoreException, IOException;

    public abstract String[] keys() throws BackingStoreException;

    public abstract String get(String var1, String var2);

    public abstract boolean getBoolean(String var1, boolean var2);

    public abstract byte[] getByteArray(String var1, byte[] var2);

    public abstract double getDouble(String var1, double var2);

    public abstract float getFloat(String var1, float var2);

    public abstract int getInt(String var1, int var2);

    public abstract long getLong(String var1, long var2);

    public abstract void put(String var1, String var2);

    public abstract void putBoolean(String var1, boolean var2);

    public abstract void putByteArray(String var1, byte[] var2);

    public abstract void putDouble(String var1, double var2);

    public abstract void putFloat(String var1, float var2);

    public abstract void putInt(String var1, int var2);

    public abstract void putLong(String var1, long var2);

    public abstract void remove(String var1);

    public abstract void clear() throws BackingStoreException;

    public abstract void flush() throws BackingStoreException;

    public abstract void sync() throws BackingStoreException;

    public abstract void removeNode() throws BackingStoreException;

    public abstract void addNodeChangeListener(NodeChangeListener var1);

    public abstract void addPreferenceChangeListener(PreferenceChangeListener var1);

    public abstract void removeNodeChangeListener(NodeChangeListener var1);

    public abstract void removePreferenceChangeListener(PreferenceChangeListener var1);

    /*
     * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class 1
    implements PrivilegedAction {
        @Override
        public Object run() {
            PreferencesFactory preferencesFactory = null;
            String string = System.getProperty("java.util.prefs.PreferencesFactory");
            if (string != null) {
                try {
                    Class clazz = Class.forName(string);
                    Object object = clazz.newInstance();
                    preferencesFactory = (PreferencesFactory)object;
                }
                catch (ClassNotFoundException classNotFoundException) {
                }
                catch (InstantiationException instantiationException) {
                }
                catch (IllegalAccessException illegalAccessException) {
                }
                catch (ClassCastException classCastException) {
                    // empty catch block
                }
            }
            return preferencesFactory;
        }
    }
}

