/*
 * Decompiled with CFR 0.152.
 */
package java.util.regex;

import gnu.regexp.RE;
import gnu.regexp.REException;
import gnu.regexp.RESyntax;
import java.io.Serializable;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.PatternSyntaxException;

/*
 * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Pattern
implements Serializable {
    public static final int UNIX_LINES = 1;
    public static final int CASE_INSENSITIVE = 2;
    public static final int COMMENTS = 4;
    public static final int MULTILINE = 8;
    public static final int DOTALL = 32;
    public static final int UNICODE_CASE = 64;
    public static final int CANON_EQ = 128;
    private String pattern;
    private int flags;
    private RE re;
    private static final String[] modelArray = new String[0];

    RE getRE() {
        return this.re;
    }

    private Pattern(String string, int n) throws PatternSyntaxException {
        this.pattern = string;
        this.flags = n;
        int n2 = 0;
        if ((n & 2) != 0) {
            n2 |= 2;
        }
        if ((n & 8) != 0) {
            n2 |= 8;
        }
        if ((n & 0x20) != 0) {
            n2 |= 4;
        }
        RESyntax rESyntax = RESyntax.RE_SYNTAX_PERL5;
        if ((n & 1) != 0) {
            rESyntax = new RESyntax(rESyntax);
            rESyntax.setLineSeparator("\n");
        }
        int cfr_ignored_0 = n & 4;
        try {
            this.re = new RE(string, n2, rESyntax);
            return;
        }
        catch (REException rEException) {
            throw new PatternSyntaxException(rEException.getMessage(), string, rEException.getPosition());
        }
    }

    public static Pattern compile(String string) throws PatternSyntaxException {
        return Pattern.compile(string, 0);
    }

    public static Pattern compile(String string, int n) throws PatternSyntaxException {
        return new Pattern(string, n);
    }

    public static boolean matches(String string, CharSequence charSequence) throws PatternSyntaxException {
        return Pattern.compile(string).matcher(charSequence).matches();
    }

    public String pattern() {
        return this.pattern;
    }

    public int flags() {
        return this.flags;
    }

    public Matcher matcher(CharSequence charSequence) {
        return new Matcher(this, charSequence);
    }

    public String[] split(CharSequence charSequence) {
        return this.split(charSequence, 0);
    }

    public String[] split(CharSequence charSequence, int n) {
        Object object;
        Matcher matcher = new Matcher(this, charSequence);
        Vector vector = new Vector();
        int n2 = 0;
        int n3 = 0;
        while (matcher.find()) {
            ++n2;
            int n4 = matcher.start();
            if (n3 == n4) {
                if (n != 0) {
                    vector.addElement("");
                }
            } else {
                object = charSequence.subSequence(n3, n4).toString();
                vector.addElement(object);
            }
            n3 = matcher.end();
            if (n2 == n) break;
        }
        if (!(n2 == n || "".equals(object = charSequence.subSequence(n3, charSequence.length()).toString()) && n == 0)) {
            vector.addElement(object);
        }
        object = new String[vector.size()];
        vector.copyInto((Object[])object);
        return object;
    }
}

