/*
 * Decompiled with CFR 0.152.
 */
package javax.naming;

import java.applet.Applet;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.OperationNotSupportedException;
import javax.naming.spi.NamingManager;

/*
 * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InitialContext
implements Context {
    protected Context defaultInitCtx;
    protected boolean gotDefault;
    protected Hashtable myProps;
    private static final String[] colon_list = new String[]{"java.naming.factory.object", "java.naming.factory.url.pkgs", "java.naming.factory.state"};

    public InitialContext(Hashtable hashtable) {
        this.Block$();
        this.init(hashtable);
    }

    protected InitialContext(boolean bl) {
        this.Block$();
        if (!bl) {
            this.init(null);
        }
    }

    public InitialContext() {
        this.Block$();
        this.init(null);
    }

    protected void init(Hashtable hashtable) {
        InputStream inputStream;
        Properties properties;
        Object object;
        Object object2;
        String[] stringArray = new String[]{"java.naming.dns.url", "java.naming.factory.initial", "java.naming.factory.object", "java.naming.provider.url", "java.naming.factory.state", "java.naming.factory.url.pkgs"};
        this.myProps = hashtable != null ? (Hashtable)hashtable.clone() : new Hashtable();
        Applet applet = (Applet)this.myProps.get("java.naming.applet");
        int n = stringArray.length - 1;
        while (n >= 0) {
            object2 = this.myProps.get(stringArray[n]);
            if (object2 == null) {
                if (applet != null) {
                    object2 = applet.getParameter(stringArray[n]);
                }
                if (object2 == null) {
                    object2 = System.getProperty(stringArray[n]);
                }
                if (object2 != null) {
                    this.myProps.put(stringArray[n], object2);
                }
            }
            --n;
        }
        try {
            object = Thread.currentThread().getContextClassLoader().getResources("jndi.naming");
            while (object.hasMoreElements()) {
                object2 = (URL)object.nextElement();
                properties = new Properties();
                try {
                    inputStream = ((URL)object2).openStream();
                    properties.load(inputStream);
                    inputStream.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                InitialContext.merge(this.myProps, properties);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        object = System.getProperty("gnu.classpath.home.url");
        if (object != null) {
            object2 = new StringBuffer().append((String)object).append("/jndi.properties").toString();
            properties = new Properties();
            try {
                inputStream = new URL((String)object2).openStream();
                properties.load(inputStream);
                inputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            InitialContext.merge(this.myProps, properties);
        }
    }

    private static void merge(Hashtable hashtable, Hashtable hashtable2) {
        Enumeration enumeration = hashtable2.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            Object object = hashtable.get(string);
            if (object == null) {
                hashtable.put(string, hashtable2.get(string));
                continue;
            }
            if (string.compareTo(colon_list[0]) != 0 && string.compareTo(colon_list[1]) != 0 && string.compareTo(colon_list[2]) != 0 && string.compareTo(colon_list[3]) != 0) continue;
            String string2 = (String)hashtable2.get(string);
            hashtable.put(string, new StringBuffer().append((String)object).append(":").append(string2).toString());
        }
    }

    protected Context getDefaultInitCtx() throws NamingException {
        if (!this.gotDefault) {
            this.defaultInitCtx = NamingManager.getInitialContext(this.myProps);
            this.gotDefault = true;
        }
        return this.defaultInitCtx;
    }

    protected Context getURLOrDefaultInitCtx(Name name) throws NamingException {
        if (name.size() > 0) {
            return this.getURLOrDefaultInitCtx(name.get(0));
        }
        return this.getDefaultInitCtx();
    }

    protected Context getURLOrDefaultInitCtx(String string) throws NamingException {
        Context context;
        String string2 = null;
        if (NamingManager.hasInitialContextFactoryBuilder()) {
            return this.getDefaultInitCtx();
        }
        int n = string.indexOf(58);
        int n2 = string.indexOf(47);
        if (n > 0 && (n2 == -1 || n < n2)) {
            string2 = string.substring(0, n);
        }
        if (string2 != null && (context = NamingManager.getURLContext(string2, this.myProps)) != null) {
            return context;
        }
        return this.getDefaultInitCtx();
    }

    @Override
    public void bind(Name name, Object object) throws NamingException {
        this.getURLOrDefaultInitCtx(name).bind(name, object);
    }

    @Override
    public void bind(String string, Object object) throws NamingException {
        this.getURLOrDefaultInitCtx(string).bind(string, object);
    }

    @Override
    public Object lookup(Name name) throws NamingException {
        return this.getURLOrDefaultInitCtx(name).lookup(name);
    }

    @Override
    public Object lookup(String string) throws NamingException {
        return this.getURLOrDefaultInitCtx(string).lookup(string);
    }

    @Override
    public void rebind(Name name, Object object) throws NamingException {
        this.getURLOrDefaultInitCtx(name).rebind(name, object);
    }

    @Override
    public void rebind(String string, Object object) throws NamingException {
        this.getURLOrDefaultInitCtx(string).rebind(string, object);
    }

    @Override
    public void unbind(Name name) throws NamingException {
        this.getURLOrDefaultInitCtx(name).unbind(name);
    }

    @Override
    public void unbind(String string) throws NamingException {
        this.getURLOrDefaultInitCtx(string).unbind(string);
    }

    @Override
    public void rename(Name name, Name name2) throws NamingException {
        this.getURLOrDefaultInitCtx(name).rename(name, name2);
    }

    @Override
    public void rename(String string, String string2) throws NamingException {
        this.getURLOrDefaultInitCtx(string).rename(string, string2);
    }

    @Override
    public NamingEnumeration list(Name name) throws NamingException {
        return this.getURLOrDefaultInitCtx(name).list(name);
    }

    @Override
    public NamingEnumeration list(String string) throws NamingException {
        return this.getURLOrDefaultInitCtx(string).list(string);
    }

    @Override
    public NamingEnumeration listBindings(Name name) throws NamingException {
        return this.getURLOrDefaultInitCtx(name).listBindings(name);
    }

    @Override
    public NamingEnumeration listBindings(String string) throws NamingException {
        return this.getURLOrDefaultInitCtx(string).listBindings(string);
    }

    @Override
    public void destroySubcontext(Name name) throws NamingException {
        this.getURLOrDefaultInitCtx(name).destroySubcontext(name);
    }

    @Override
    public void destroySubcontext(String string) throws NamingException {
        this.getURLOrDefaultInitCtx(string).destroySubcontext(string);
    }

    @Override
    public Context createSubcontext(Name name) throws NamingException {
        return this.getURLOrDefaultInitCtx(name).createSubcontext(name);
    }

    @Override
    public Context createSubcontext(String string) throws NamingException {
        return this.getURLOrDefaultInitCtx(string).createSubcontext(string);
    }

    @Override
    public Object lookupLink(Name name) throws NamingException {
        return this.getURLOrDefaultInitCtx(name).lookupLink(name);
    }

    @Override
    public Object lookupLink(String string) throws NamingException {
        return this.getURLOrDefaultInitCtx(string).lookupLink(string);
    }

    @Override
    public NameParser getNameParser(Name name) throws NamingException {
        return this.getURLOrDefaultInitCtx(name).getNameParser(name);
    }

    @Override
    public NameParser getNameParser(String string) throws NamingException {
        return this.getURLOrDefaultInitCtx(string).getNameParser(string);
    }

    @Override
    public Name composeName(Name name, Name name2) throws NamingException {
        return this.getURLOrDefaultInitCtx(name).composeName(name, name2);
    }

    @Override
    public String composeName(String string, String string2) throws NamingException {
        return this.getURLOrDefaultInitCtx(string).composeName(string, string2);
    }

    @Override
    public Object addToEnvironment(String string, Object object) throws NamingException {
        return this.myProps.put(string, object);
    }

    @Override
    public Object removeFromEnvironment(String string) throws NamingException {
        return this.myProps.remove(string);
    }

    @Override
    public Hashtable getEnvironment() throws NamingException {
        return this.myProps;
    }

    @Override
    public void close() throws NamingException {
        throw new OperationNotSupportedException();
    }

    @Override
    public String getNameInNamespace() throws NamingException {
        throw new OperationNotSupportedException();
    }

    private /* synthetic */ void Block$() {
        this.gotDefault = false;
    }
}

