/*
 * Decompiled with CFR 0.152.
 */
package javax.naming.directory;

import java.util.NoSuchElementException;
import java.util.Vector;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.OperationNotSupportedException;
import javax.naming.directory.Attribute;
import javax.naming.directory.DirContext;

/*
 * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BasicAttribute
implements Attribute {
    protected String attrID;
    protected boolean ordered;
    protected transient Vector values;

    private BasicAttribute() {
    }

    public BasicAttribute(String string) {
        this(string, false);
    }

    public BasicAttribute(String string, boolean bl) {
        this.attrID = string;
        this.ordered = bl;
        this.values = new Vector();
    }

    public BasicAttribute(String string, Object object) {
        this(string, object, false);
    }

    public BasicAttribute(String string, Object object, boolean bl) {
        this.attrID = string;
        this.ordered = bl;
        this.values = new Vector();
        this.values.add(object);
    }

    @Override
    public void add(int n, Object object) {
        if (!this.ordered && this.contains(object)) {
            throw new IllegalStateException("value already in attribute");
        }
        this.values.add(n, object);
    }

    @Override
    public boolean add(Object object) {
        if (!this.ordered && this.contains(object)) {
            throw new IllegalStateException("value already in attribute");
        }
        return this.values.add(object);
    }

    @Override
    public void clear() {
        this.values.clear();
    }

    @Override
    public Object clone() {
        BasicAttribute basicAttribute = new BasicAttribute();
        basicAttribute.attrID = this.attrID;
        basicAttribute.ordered = this.ordered;
        basicAttribute.values = (Vector)this.values.clone();
        return basicAttribute;
    }

    @Override
    public boolean contains(Object object) {
        int n = 0;
        while (n < this.values.size()) {
            if (this.equals(object, this.values.get(n))) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public boolean equals(Object object) {
        if (!(object instanceof BasicAttribute)) {
            return false;
        }
        BasicAttribute basicAttribute = (BasicAttribute)object;
        if (this.ordered != basicAttribute.ordered || !this.attrID.equals(basicAttribute.attrID) || this.values.size() != basicAttribute.values.size()) {
            return false;
        }
        int n = 0;
        while (n < this.values.size()) {
            boolean bl = false;
            if (this.ordered) {
                bl = this.equals(this.values.get(n), basicAttribute.values.get(n));
            } else {
                int n2 = 0;
                while (n2 < basicAttribute.values.size()) {
                    if (this.equals(this.values.get(n), basicAttribute.values.get(n2))) {
                        bl = true;
                        break;
                    }
                    ++n2;
                }
            }
            if (!bl) {
                return false;
            }
            ++n;
        }
        return true;
    }

    @Override
    public Object get() {
        if (this.values.size() == 0) {
            throw new NoSuchElementException("no values");
        }
        return this.get(0);
    }

    @Override
    public Object get(int n) {
        return this.values.get(n);
    }

    @Override
    public NamingEnumeration getAll() {
        return new BasicAttributeEnumeration();
    }

    @Override
    public DirContext getAttributeDefinition() throws OperationNotSupportedException, NamingException {
        throw new OperationNotSupportedException();
    }

    @Override
    public DirContext getAttributeSyntaxDefinition() throws OperationNotSupportedException, NamingException {
        throw new OperationNotSupportedException();
    }

    @Override
    public String getID() {
        return this.attrID;
    }

    public int hashCode() {
        int n = this.attrID.hashCode();
        int n2 = 0;
        while (n2 < this.values.size()) {
            Object object = this.values.get(n2);
            if (object != null) {
                if (object instanceof Object[]) {
                    Object[] objectArray = (Object[])object;
                    int n3 = 0;
                    while (n3 < objectArray.length) {
                        n += objectArray[n3].hashCode();
                        ++n3;
                    }
                } else {
                    n += object.hashCode();
                }
            }
            ++n2;
        }
        return n;
    }

    @Override
    public boolean isOrdered() {
        return this.ordered;
    }

    @Override
    public Object remove(int n) {
        return this.values.remove(n);
    }

    @Override
    public boolean remove(Object object) {
        int n = 0;
        while (n < this.values.size()) {
            if (this.equals(object, this.values.get(n))) {
                this.values.remove(n);
                return true;
            }
            ++n;
        }
        return false;
    }

    @Override
    public Object set(int n, Object object) {
        if (!this.ordered && this.contains(object)) {
            throw new IllegalStateException("value already in attribute");
        }
        return this.values.set(n, object);
    }

    @Override
    public int size() {
        return this.values.size();
    }

    public String toString() {
        String string = this.attrID;
        int n = 0;
        while (n < this.values.size()) {
            string = string.concat(new StringBuffer().append(";").append(this.values.get(n).toString()).toString());
            ++n;
        }
        return string;
    }

    private boolean equals(Object object, Object object2) {
        if (object == null) {
            return object2 == null;
        }
        if (object instanceof Object[]) {
            if (!(object2 instanceof Object[])) {
                return false;
            }
            Object[] objectArray = (Object[])object;
            Object[] objectArray2 = (Object[])object2;
            if (objectArray.length != objectArray2.length) {
                return false;
            }
            int n = 0;
            while (n < objectArray.length) {
                if (!objectArray[n].equals(objectArray2[n])) {
                    return false;
                }
                ++n;
            }
            return true;
        }
        return object.equals(object2);
    }

    /*
     * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class BasicAttributeEnumeration
    implements NamingEnumeration {
        int where;

        public BasicAttributeEnumeration() {
            this.Block$();
        }

        @Override
        public void close() throws NamingException {
        }

        @Override
        public boolean hasMore() throws NamingException {
            return this.hasMoreElements();
        }

        @Override
        public Object next() throws NamingException {
            return this.nextElement();
        }

        @Override
        public boolean hasMoreElements() {
            return this.where < BasicAttribute.this.values.size();
        }

        @Override
        public Object nextElement() throws NoSuchElementException {
            if (this.where + 1 >= BasicAttribute.this.values.size()) {
                throw new NoSuchElementException("no more elements");
            }
            ++this.where;
            return BasicAttribute.this.values.get(this.where);
        }

        private /* synthetic */ void Block$() {
            this.where = -1;
        }
    }
}

