/*
 * Decompiled with CFR 0.152.
 */
package javax.naming.ldap;

import java.util.Hashtable;
import javax.naming.Context;
import javax.naming.NamingException;
import javax.naming.NoInitialContextException;
import javax.naming.NotContextException;
import javax.naming.directory.InitialDirContext;
import javax.naming.ldap.Control;
import javax.naming.ldap.ExtendedRequest;
import javax.naming.ldap.ExtendedResponse;
import javax.naming.ldap.LdapContext;

/*
 * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InitialLdapContext
extends InitialDirContext
implements LdapContext {
    public InitialLdapContext() throws NamingException {
        this(null, null);
    }

    public InitialLdapContext(Hashtable hashtable, Control[] controlArray) throws NamingException {
        super(false);
        if (controlArray != null) {
            hashtable = hashtable == null ? new Hashtable() : (Hashtable)hashtable.clone();
            hashtable.put("java.naming.ldap.control.connect", controlArray);
        }
        this.init(hashtable);
    }

    private LdapContext getDefaultInitLdapCtx() throws NamingException {
        Context context = this.getDefaultInitCtx();
        if (context == null) {
            throw new NoInitialContextException();
        }
        if (!(context instanceof LdapContext)) {
            throw new NotContextException();
        }
        return (LdapContext)context;
    }

    @Override
    public ExtendedResponse extendedOperation(ExtendedRequest extendedRequest) throws NamingException {
        return this.getDefaultInitLdapCtx().extendedOperation(extendedRequest);
    }

    @Override
    public Control[] getConnectControls() throws NamingException {
        return this.getDefaultInitLdapCtx().getConnectControls();
    }

    @Override
    public Control[] getRequestControls() throws NamingException {
        return this.getDefaultInitLdapCtx().getRequestControls();
    }

    @Override
    public Control[] getResponseControls() throws NamingException {
        return this.getDefaultInitLdapCtx().getResponseControls();
    }

    @Override
    public LdapContext newInstance(Control[] controlArray) throws NamingException {
        return this.getDefaultInitLdapCtx().newInstance(controlArray);
    }

    @Override
    public void reconnect(Control[] controlArray) throws NamingException {
        this.getDefaultInitLdapCtx().reconnect(controlArray);
    }

    @Override
    public void setRequestControls(Control[] controlArray) throws NamingException {
        this.getDefaultInitLdapCtx().setRequestControls(controlArray);
    }
}

