/*
 * Decompiled with CFR 0.152.
 */
package javax.sound.midi;

import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.MidiMessage;
import org.tritonus.share.midi.MidiUtils;

/*
 * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MetaMessage
extends MidiMessage {
    public static final int META = 255;
    private static final byte[] DEFAULT_MESSAGE = new byte[]{-1, 47, 0};

    public MetaMessage() {
        super(null);
    }

    protected MetaMessage(byte[] byArray) {
        super(byArray);
    }

    public void setMessage(int n, byte[] byArray, int n2) throws InvalidMidiDataException {
        if (n > 127) {
            throw new InvalidMidiDataException("type must not exceed 127");
        }
        byte[] byArray2 = MidiUtils.getVariableLengthQuantity(n2);
        int n3 = 2 + n2;
        byte[] byArray3 = new byte[n3];
        byArray3[0] = -1;
        byArray3[1] = (byte)n;
        System.arraycopy(byArray, 0, byArray3, 2, n2);
        super.setMessage(byArray3, n3);
    }

    public int getType() {
        int n = MidiUtils.getUnsignedInteger(this.getMessage()[1]);
        return n;
    }

    public byte[] getData() {
        int n = this.getLength() - 2;
        byte[] byArray = new byte[n];
        System.arraycopy(this.getMessage(), 2, byArray, 0, n);
        return byArray;
    }

    @Override
    public Object clone() {
        byte[] byArray = this.getMessage();
        MetaMessage metaMessage = new MetaMessage(byArray);
        return metaMessage;
    }
}

