/*
 * Decompiled with CFR 0.152.
 */
package javax.sound.midi;

import java.util.Iterator;
import java.util.Vector;
import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.Patch;
import javax.sound.midi.Track;

/*
 * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Sequence {
    public static final float PPQ = 0.0f;
    public static final float SMPTE_24 = 24.0f;
    public static final float SMPTE_25 = 25.0f;
    public static final float SMPTE_30DROP = 29.97f;
    public static final float SMPTE_30 = 30.0f;
    private static final Track[] EMPTY_TRACK_ARRAY = new Track[0];
    protected float divisionType;
    protected int resolution;
    protected Vector tracks;

    public Sequence(float f, int n) throws InvalidMidiDataException {
        this(f, n, 0);
    }

    public Sequence(float f, int n, int n2) throws InvalidMidiDataException {
        if (f != 0.0f && f != 24.0f && f != 25.0f && f != 29.97f && f != 30.0f) {
            throw new InvalidMidiDataException(new StringBuffer().append("Invalid division type: ").append(f).toString());
        }
        this.divisionType = f;
        this.resolution = n;
        this.tracks = new Vector();
        int n3 = 0;
        while (n3 < n2) {
            this.createTrack();
            ++n3;
        }
    }

    public float getDivisionType() {
        return this.divisionType;
    }

    public int getResolution() {
        return this.resolution;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Track createTrack() {
        Track track = new Track();
        Vector vector = this.tracks;
        synchronized (vector) {
            this.tracks.add(track);
        }
        return track;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean deleteTrack(Track track) {
        Vector vector = this.tracks;
        synchronized (vector) {
            return this.tracks.remove(track);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Track[] getTracks() {
        Vector vector = this.tracks;
        synchronized (vector) {
            return (Track[])this.tracks.toArray(EMPTY_TRACK_ARRAY);
        }
    }

    public long getMicrosecondLength() {
        if (this.getDivisionType() != 0.0f) {
            return (long)((float)(this.getTickLength() * 1000000L) / (this.getDivisionType() * (float)this.getResolution()));
        }
        return -1L;
    }

    public long getTickLength() {
        long l = 0L;
        Iterator iterator = this.tracks.iterator();
        while (iterator.hasNext()) {
            Track track = (Track)iterator.next();
            l = Math.max(l, track.ticks());
        }
        return l;
    }

    public Patch[] getPatchList() {
        return new Patch[0];
    }
}

