/*
 * Decompiled with CFR 0.152.
 */
package javax.sound.midi;

import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.MidiMessage;

/*
 * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ShortMessage
extends MidiMessage {
    private static final boolean CHECK_SECOND_BYTE = false;
    public static final int NOTE_OFF = 128;
    public static final int NOTE_ON = 144;
    public static final int POLY_PRESSURE = 160;
    public static final int CONTROL_CHANGE = 176;
    public static final int PROGRAM_CHANGE = 192;
    public static final int CHANNEL_PRESSURE = 208;
    public static final int PITCH_BEND = 224;
    public static final int MIDI_TIME_CODE = 241;
    public static final int SONG_POSITION_POINTER = 242;
    public static final int SONG_SELECT = 243;
    public static final int TUNE_REQUEST = 246;
    public static final int END_OF_EXCLUSIVE = 247;
    public static final int TIMING_CLOCK = 248;
    public static final int START = 250;
    public static final int CONTINUE = 251;
    public static final int STOP = 252;
    public static final int ACTIVE_SENSING = 254;
    public static final int SYSTEM_RESET = 255;
    private static final int[] sm_anChannelMessageLength = new int[]{-1, -1, -1, -1, -1, -1, -1, -1, 2, 2, 2, 2, 1, 1, 2};
    private static final int[] sm_anSystemMessageLength = new int[]{-1, 2, 3, 2, -1, -1, 1, 0, 1, -1, 1, 1, 1, -1, 1, 1};

    public ShortMessage() {
        this(null);
    }

    protected ShortMessage(byte[] byArray) {
        super(byArray);
    }

    @Override
    public Object clone() {
        byte[] byArray = this.getMessage();
        ShortMessage shortMessage = new ShortMessage(byArray);
        return shortMessage;
    }

    public void setMessage(int n) throws InvalidMidiDataException {
        if (this.getDataLength(n) != 0) {
            throw new InvalidMidiDataException("not a one-byte command");
        }
        byte[] byArray = new byte[]{(byte)n};
        this.setMessage(byArray, 1);
    }

    public void setMessage(int n, int n2, int n3) throws InvalidMidiDataException {
        int n4 = this.getDataLength(n);
        if (n4 < 1) {
            throw new InvalidMidiDataException("not a two- or three-byte command");
        }
        byte[] byArray = new byte[n4 + 1];
        byArray[0] = (byte)n;
        byArray[1] = (byte)n2;
        if (n4 == 2) {
            byArray[2] = (byte)n3;
        }
        this.setMessage(byArray, n4 + 1);
    }

    public void setMessage(int n, int n2, int n3, int n4) throws InvalidMidiDataException {
        this.setMessage(n & 0xF0 | n2 & 0xF, n3, n4);
    }

    public int getChannel() {
        return this.getStatus() & 0xF;
    }

    public int getCommand() {
        return this.getStatus() & 0xF0;
    }

    public int getData1() {
        return this.getDataByte(1);
    }

    public int getData2() {
        return this.getDataByte(2);
    }

    private int getDataByte(int n) {
        int n2 = 0;
        if (this.getLength() >= n) {
            n2 = this.getMessage()[n];
        }
        return n2;
    }

    protected final int getDataLength(int n) throws InvalidMidiDataException {
        int n2 = 0;
        n2 = n < 240 ? sm_anChannelMessageLength[n >> 4 & 0xF] : sm_anSystemMessageLength[n & 0xF];
        if (n2 == -1) {
            throw new InvalidMidiDataException("status byte not usable for ShortMessage");
        }
        return n2;
    }
}

