/*
 * Decompiled with CFR 0.152.
 */
package javax.sound.sampled;

import java.io.IOException;
import java.io.InputStream;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.TargetDataLine;
import org.tritonus.share.TDebug;
import org.tritonus.share.sampled.AudioUtils;

/*
 * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AudioInputStream
extends InputStream {
    private static final boolean CHECK_LENGTHS = true;
    protected InputStream stream;
    protected AudioFormat format;
    protected long frameLength;
    protected int frameSize;
    private int m_nCheckFrameSize;
    protected long framePos;
    private long m_lPosition;
    private long m_lLengthInBytes;
    private long m_lMarkedPosition;

    public AudioInputStream(InputStream inputStream, AudioFormat audioFormat, long l) {
        if (TDebug.TraceAudioInputStream) {
            TDebug.out(new StringBuffer().append("AudioInputStream.<init>: inputStream: ").append(inputStream).toString());
        }
        this.stream = inputStream;
        this.format = audioFormat;
        this.frameLength = l;
        this.m_nCheckFrameSize = this.frameSize = audioFormat.getFrameSize();
        if (this.m_nCheckFrameSize < 1) {
            this.m_nCheckFrameSize = 1;
        }
        this.m_lLengthInBytes = AudioUtils.getLengthInBytes(audioFormat, l);
        this.m_lPosition = 0L;
        this.updateFramePosition();
    }

    public AudioInputStream(TargetDataLine targetDataLine) {
        this(new TargetDataLineInputStream(targetDataLine), targetDataLine.getFormat(), -1L);
    }

    public AudioFormat getFormat() {
        return this.format;
    }

    public long getFrameLength() {
        return this.frameLength;
    }

    @Override
    public int read() throws IOException {
        if (this.getCheckFrameSize() != 1) {
            throw new IOException("frame size must be 1 to read a single byte");
        }
        if (this.isEndReached()) {
            return -1;
        }
        int n = this.stream.read();
        if (n != -1) {
            ++this.m_lPosition;
            this.updateFramePosition();
        }
        return n;
    }

    @Override
    public int read(byte[] byArray) throws IOException {
        return this.read(byArray, 0, byArray.length);
    }

    @Override
    public int read(byte[] byArray, int n, int n2) throws IOException {
        int n3;
        if (this.isEndReached()) {
            return -1;
        }
        if (n2 % this.getCheckFrameSize() != 0) {
            throw new IOException(new StringBuffer().append("length must be a multiple of the frame size (length=").append(n2).append(", frameSize=").append(this.getCheckFrameSize()).append(")").toString());
        }
        if (this.m_lLengthInBytes != -1L) {
            n2 = (int)Math.min((long)n2, this.m_lLengthInBytes - this.m_lPosition);
        }
        int n4 = 0;
        do {
            if ((n3 = this.stream.read(byArray, n, n2)) <= 0) continue;
            n4 += n3;
            n2 -= n3;
            n += n3;
        } while (n3 > 0 && n2 > 0);
        if (n4 <= 0 && n3 == -1) {
            n4 = -1;
        } else {
            this.m_lPosition += (long)n4;
            this.updateFramePosition();
        }
        return n4;
    }

    @Override
    public long skip(long l) throws IOException {
        if (l % (long)this.getCheckFrameSize() != 0L) {
            throw new IOException("skip must be a multiple of the frame size");
        }
        if (this.m_lLengthInBytes != -1L) {
            l = (int)Math.min(l, this.m_lLengthInBytes - this.m_lPosition);
        }
        long l2 = this.stream.skip(l);
        this.m_lPosition += l2;
        this.updateFramePosition();
        return l2;
    }

    @Override
    public int available() throws IOException {
        if (this.m_lLengthInBytes == -1L) {
            return this.stream.available();
        }
        return (int)Math.min((long)this.stream.available(), this.m_lLengthInBytes - this.m_lPosition);
    }

    @Override
    public void close() throws IOException {
        this.stream.close();
    }

    @Override
    public void mark(int n) {
        this.stream.mark(n);
        this.m_lMarkedPosition = this.m_lPosition;
    }

    @Override
    public void reset() throws IOException {
        this.stream.reset();
        this.m_lPosition = this.m_lMarkedPosition;
        this.updateFramePosition();
    }

    @Override
    public boolean markSupported() {
        return this.stream.markSupported();
    }

    private int getCheckFrameSize() {
        return this.m_nCheckFrameSize;
    }

    private boolean isEndReached() {
        return this.m_lPosition >= this.m_lLengthInBytes && this.m_lLengthInBytes != -1L;
    }

    private void updateFramePosition() {
        this.framePos = this.m_lPosition / (long)this.getCheckFrameSize();
    }

    /*
     * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class TargetDataLineInputStream
    extends InputStream {
        private TargetDataLine m_targetDataLine;
        private byte[] m_abSingleByteBuffer;

        public TargetDataLineInputStream(TargetDataLine targetDataLine) {
            this.Block$();
            this.m_targetDataLine = targetDataLine;
        }

        @Override
        public int read() {
            int n;
            if (this.m_abSingleByteBuffer == null) {
                this.m_abSingleByteBuffer = new byte[1];
            }
            if ((n = this.read(this.m_abSingleByteBuffer, 0, 1)) < 0) {
                return -1;
            }
            return this.m_abSingleByteBuffer[0];
        }

        @Override
        public int read(byte[] byArray, int n, int n2) {
            return this.m_targetDataLine.read(byArray, n, n2);
        }

        private /* synthetic */ void Block$() {
            this.m_abSingleByteBuffer = null;
        }
    }
}

