/*
 * Decompiled with CFR 0.152.
 */
package javax.sound.sampled;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.Line;
import org.tritonus.share.TDebug;
import org.tritonus.share.sampled.AudioFormats;

/*
 * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface DataLine
extends Line {
    public void drain();

    public void flush();

    public void start();

    public void stop();

    public boolean isRunning();

    public boolean isActive();

    public AudioFormat getFormat();

    public int getBufferSize();

    public int available();

    public int getFramePosition();

    public long getMicrosecondPosition();

    public float getLevel();

    /*
     * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Info
    extends Line.Info {
        private AudioFormat[] EMPTY_AUDIO_FORMAT_ARRAY;
        private List m_audioFormats;
        private int m_nMinBufferSize;
        private int m_nMaxBufferSize;

        public Info(Class clazz, AudioFormat[] audioFormatArray, int n, int n2) {
            super(clazz);
            this.Block$();
            this.m_audioFormats = Arrays.asList(audioFormatArray);
            this.m_nMinBufferSize = n;
            this.m_nMaxBufferSize = n2;
        }

        public Info(Class clazz, AudioFormat audioFormat, int n) {
            this(clazz, new AudioFormat[]{audioFormat}, n, n);
        }

        public Info(Class clazz, AudioFormat audioFormat) {
            this(clazz, audioFormat, -1);
        }

        public AudioFormat[] getFormats() {
            return (AudioFormat[])this.m_audioFormats.toArray(this.EMPTY_AUDIO_FORMAT_ARRAY);
        }

        public boolean isFormatSupported(AudioFormat audioFormat) {
            Iterator iterator = this.m_audioFormats.iterator();
            while (iterator.hasNext()) {
                AudioFormat audioFormat2 = (AudioFormat)iterator.next();
                if (!AudioFormats.matches(audioFormat2, audioFormat)) continue;
                return true;
            }
            return false;
        }

        public int getMinBufferSize() {
            return this.m_nMinBufferSize;
        }

        public int getMaxBufferSize() {
            return this.m_nMaxBufferSize;
        }

        @Override
        public boolean matches(Line.Info info) {
            if (TDebug.TraceDataLine) {
                TDebug.out(">DataLine.Info.matches(): called");
                TDebug.out(new StringBuffer().append("DataLine.Info.matches(): own info: ").append(this.toString()).toString());
                TDebug.out(new StringBuffer().append("DataLine.Info.matches(): test info: ").append(info.toString()).toString());
            }
            if (!super.matches(info)) {
                if (TDebug.TraceDataLine) {
                    TDebug.out("<DataLine.Info.matches(): super.matches does not match()");
                }
                return false;
            }
            Info info2 = (Info)info;
            if (this.getMinBufferSize() != -1 && info2.getMinBufferSize() != -1 && this.getMinBufferSize() < info2.getMinBufferSize() || this.getMaxBufferSize() != -1 && info2.getMaxBufferSize() != -1 && this.getMaxBufferSize() > info2.getMaxBufferSize()) {
                TDebug.out("<DataLine.Info.matches(): buffer sizes do not match");
                return false;
            }
            Iterator iterator = this.m_audioFormats.iterator();
            while (iterator.hasNext()) {
                AudioFormat audioFormat = (AudioFormat)iterator.next();
                if (TDebug.TraceDataLine) {
                    TDebug.out(new StringBuffer().append("checking if supported: ").append(audioFormat).toString());
                }
                if (info2.isFormatSupported(audioFormat)) continue;
                if (TDebug.TraceDataLine) {
                    TDebug.out("< format doesn't match");
                }
                return false;
            }
            if (TDebug.TraceDataLine) {
                TDebug.out("< matches: true");
            }
            return true;
        }

        @Override
        public String toString() {
            AudioFormat[] audioFormatArray = this.getFormats();
            String string = "formats:\n";
            int n = 0;
            while (n < audioFormatArray.length) {
                string = string.concat(new StringBuffer().append(audioFormatArray[n].toString()).append("\n").toString());
                ++n;
            }
            return new StringBuffer().append(super.toString()).append(string).append("minBufferSize=").append(this.getMinBufferSize()).append(" maxBufferSize=").append(this.getMaxBufferSize()).toString();
        }

        private /* synthetic */ void Block$() {
            this.EMPTY_AUDIO_FORMAT_ARRAY = new AudioFormat[0];
        }
    }
}

