/*
 * Decompiled with CFR 0.152.
 */
package javax.sound.sampled.spi;

import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import org.tritonus.share.TDebug;

/*
 * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class FormatConversionProvider {
    public abstract AudioFormat.Encoding[] getSourceEncodings();

    public abstract AudioFormat.Encoding[] getTargetEncodings();

    public boolean isSourceEncodingSupported(AudioFormat.Encoding encoding) {
        Object[] objectArray = this.getSourceEncodings();
        return FormatConversionProvider.arrayContains(objectArray, encoding);
    }

    public boolean isTargetEncodingSupported(AudioFormat.Encoding encoding) {
        Object[] objectArray = this.getTargetEncodings();
        return FormatConversionProvider.arrayContains(objectArray, encoding);
    }

    public abstract AudioFormat.Encoding[] getTargetEncodings(AudioFormat var1);

    public boolean isConversionSupported(AudioFormat.Encoding encoding, AudioFormat audioFormat) {
        if (TDebug.TraceAudioConverter) {
            TDebug.out(">FormatConversionProvider.isConversionSupported(AudioFormat.Encoding, AudioFormat):");
            TDebug.out(new StringBuffer().append("class: ").append(this.getClass().getName()).toString());
            TDebug.out("checking if conversion possible");
            TDebug.out(new StringBuffer().append("from: ").append(audioFormat).toString());
            TDebug.out(new StringBuffer().append("to: ").append(encoding).toString());
        }
        Object[] objectArray = this.getTargetEncodings(audioFormat);
        boolean bl = FormatConversionProvider.arrayContains(objectArray, encoding);
        if (TDebug.TraceAudioConverter) {
            TDebug.out(new StringBuffer().append("< result=").append(bl).toString());
        }
        return bl;
    }

    public abstract AudioFormat[] getTargetFormats(AudioFormat.Encoding var1, AudioFormat var2);

    public boolean isConversionSupported(AudioFormat audioFormat, AudioFormat audioFormat2) {
        if (TDebug.TraceAudioConverter) {
            TDebug.out(">FormatConversionProvider.isConversionSupported(AudioFormat, AudioFormat):");
            TDebug.out(new StringBuffer().append("class: ").append(this.getClass().getName()).toString());
            TDebug.out("checking if conversion possible");
            TDebug.out(new StringBuffer().append("from: ").append(audioFormat2).toString());
            TDebug.out(new StringBuffer().append("to: ").append(audioFormat).toString());
        }
        AudioFormat[] audioFormatArray = this.getTargetFormats(audioFormat.getEncoding(), audioFormat2);
        int n = 0;
        while (n < audioFormatArray.length) {
            if (TDebug.TraceAudioConverter) {
                TDebug.out(new StringBuffer().append("checking against possible target format: ").append(audioFormatArray[n]).toString());
            }
            if (audioFormatArray[n] != null && audioFormatArray[n].matches(audioFormat)) {
                if (TDebug.TraceAudioConverter) {
                    TDebug.out("<result=true");
                }
                return true;
            }
            ++n;
        }
        if (TDebug.TraceAudioConverter) {
            TDebug.out("<result=false");
        }
        return false;
    }

    public abstract AudioInputStream getAudioInputStream(AudioFormat.Encoding var1, AudioInputStream var2);

    public abstract AudioInputStream getAudioInputStream(AudioFormat var1, AudioInputStream var2);

    private static boolean arrayContains(Object[] objectArray, Object object) {
        int n = 0;
        while (n < objectArray.length) {
            if (objectArray[n] != null && objectArray[n].equals(object)) {
                return true;
            }
            ++n;
        }
        return false;
    }
}

