/*
 * Decompiled with CFR 0.152.
 */
package javax.xml.parsers;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DocumentBuilder {
    protected DocumentBuilder() {
    }

    public abstract DOMImplementation getDOMImplementation();

    public abstract boolean isNamespaceAware();

    public abstract boolean isValidating();

    public abstract Document newDocument();

    static String fileToURL(File file) throws IOException {
        String string = file.getAbsolutePath();
        if (File.separatorChar != '/') {
            string = string.replace(File.separatorChar, '/');
        }
        if (!string.startsWith("/")) {
            string = new StringBuffer().append("/").append(string).toString();
        }
        if (!string.endsWith("/") && file.isDirectory()) {
            string = new StringBuffer().append(string).append("/").toString();
        }
        return new StringBuffer().append("file:").append(string).toString();
    }

    public Document parse(File file) throws SAXException, IOException {
        InputSource inputSource = new InputSource(DocumentBuilder.fileToURL(file));
        inputSource.setByteStream(new FileInputStream(file));
        return this.parse(inputSource);
    }

    public abstract Document parse(InputSource var1) throws SAXException, IOException;

    public Document parse(InputStream inputStream) throws SAXException, IOException {
        return this.parse(new InputSource(inputStream));
    }

    public Document parse(InputStream inputStream, String string) throws SAXException, IOException {
        InputSource inputSource = new InputSource(inputStream);
        inputSource.setSystemId(string);
        return this.parse(inputSource);
    }

    public Document parse(String string) throws SAXException, IOException {
        return this.parse(new InputSource(string));
    }

    public abstract void setEntityResolver(EntityResolver var1);

    public abstract void setErrorHandler(ErrorHandler var1);
}

