/*
 * Decompiled with CFR 0.152.
 */
package kaffe.awt;

import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.ImageObserver;
import java.io.File;
import java.net.URL;
import kaffe.awt.ImageClass;

/*
 * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImageSpec {
    Image img;
    boolean plain;
    String fileName;
    Class loaderCls;

    public ImageSpec(String string, Class clazz, ImageObserver imageObserver, boolean bl, boolean bl2) {
        this.loaderCls = clazz;
        this.fileName = string;
        this.plain = bl2;
        if (bl) {
            this.loadImage(imageObserver);
        }
    }

    public Image getImage() {
        if (this.img == null) {
            this.loadImage(null);
        }
        return this.img;
    }

    public boolean isPlain() {
        return this.plain;
    }

    boolean loadFromClass(ImageObserver imageObserver) {
        try {
            Class clazz = Class.forName(this.fileName);
            ImageClass imageClass = (ImageClass)clazz.newInstance();
            this.img = Toolkit.getDefaultToolkit().createImage(imageClass.source);
            if (imageObserver != null) {
                this.img.getHeight(imageObserver);
            }
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    boolean loadFromFile() {
        File file = new File(this.fileName);
        if (file.exists()) {
            this.img = Toolkit.getDefaultToolkit().getImage(this.fileName);
            return true;
        }
        return false;
    }

    boolean loadFromURL(ImageObserver imageObserver) {
        try {
            URL uRL = this.loaderCls.getResource(this.fileName);
            this.img = Toolkit.getDefaultToolkit().getImage(uRL);
            if (imageObserver != null) {
                this.img.getWidth(imageObserver);
            }
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    boolean loadImage(ImageObserver imageObserver) {
        if (this.img != null) {
            return true;
        }
        if (this.loadFromFile()) {
            return true;
        }
        if (this.loadFromClass(imageObserver)) {
            return true;
        }
        return this.loadFromURL(imageObserver);
    }
}

