/*
 * Decompiled with CFR 0.152.
 */
package kaffe.io;

import java.io.InputStream;
import java.io.ObjectInputStream;
import java.util.Arrays;
import kaffe.io.ByteToCharConverter;

/*
 * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ByteToCharEUC_JP
extends ByteToCharConverter {
    private static final boolean US_ASCII = true;
    static boolean tableLoaded = false;
    static String encodingRoot = "kaffe.io";
    static char[] cs1table;
    static char[] uni1table;
    static byte[] cs2table;
    static char[] uni2table;
    static char[] cs3table;
    static char[] uni3table;

    @Override
    public int convert(byte[] byArray, int n, int n2, char[] cArray, int n3, int n4) {
        if (!tableLoaded) {
            ByteToCharEUC_JP.loadTable();
        }
        int n5 = n3;
        int n6 = n3 + n4;
        int n7 = n;
        int n8 = n + n2;
        while (n7 < n8 && n5 < n6) {
            int n9;
            int n10 = byArray[n7] & 0xFF;
            if ((n10 & 0x80) == 0) {
                cArray[n5++] = (char)n10;
            } else if (n10 == 142) {
                if (n7 + 1 >= n8) break;
                cArray[n5++] = (n9 = Arrays.binarySearch(cs2table, (byte)(n10 = byArray[++n7] & 0xFF))) >= 0 ? uni2table[n9] : (char)'\u0000';
            } else if (n10 == 143) {
                if (n7 + 2 >= n8) break;
                n10 = ((byArray[n7 + 1] & 0xFF) << 8) + (byArray[n7 + 2] & 0xFF);
                n7 += 2;
                n9 = Arrays.binarySearch(cs3table, (char)n10);
                cArray[n5++] = n9 >= 0 ? uni3table[n9] : (char)'\u0000';
            } else {
                if (n7 + 1 >= n8) break;
                n10 = ((byArray[n7] & 0xFF) << 8) + (byArray[n7 + 1] & 0xFF);
                ++n7;
                n9 = Arrays.binarySearch(cs1table, (char)n10);
                cArray[n5++] = n9 >= 0 ? uni1table[n9] : (char)'\u0000';
            }
            ++n7;
        }
        if (n8 > n7) {
            this.carry(byArray, n7, n8 - n7);
        }
        return n5 - n3;
    }

    @Override
    public int getNumberOfChars(byte[] byArray, int n, int n2) {
        return n2;
    }

    private static void loadTable() {
        try {
            String string = new StringBuffer().append(encodingRoot).append(".ByteToCharEUC_JP").toString();
            InputStream inputStream = ClassLoader.getSystemResourceAsStream(new StringBuffer().append(string.replace('.', '/')).append(".tbl").toString());
            if (inputStream != null) {
                ObjectInputStream objectInputStream = new ObjectInputStream(inputStream);
                cs1table = (char[])objectInputStream.readObject();
                uni1table = (char[])objectInputStream.readObject();
                cs2table = (byte[])objectInputStream.readObject();
                uni2table = (char[])objectInputStream.readObject();
                cs3table = (char[])objectInputStream.readObject();
                uni3table = (char[])objectInputStream.readObject();
                tableLoaded = true;
            }
        }
        catch (Exception exception) {
            System.err.println(new StringBuffer().append("ByteToCharEUC_JP.tbl could not be loaded").append(exception).toString());
        }
        if (!tableLoaded) {
            cs1table = new char[0];
            uni1table = new char[0];
            cs2table = new byte[0];
            uni2table = new char[0];
            cs3table = new char[0];
            uni3table = new char[0];
            tableLoaded = true;
            System.err.println("CharToByteEUC_JP.tbl could not be loaded");
        }
    }
}

