/*
 * Decompiled with CFR 0.152.
 */
package kaffe.lang;

import java.io.FilterInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.Enumeration;
import java.util.Vector;
import kaffe.lang.ApplicationException;
import kaffe.lang.ApplicationResource;
import kaffe.lang.ClassPathReader;
import kaffe.lang.ResourceReader;

/*
 * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Application
extends ClassLoader
implements Runnable {
    private Method runMethod;
    private String[] arguments;
    private Vector resources;
    private ResourceReader reader;
    private ApplicationResource initResource;
    private Thread tid;
    private Throwable exception;
    private int exitcode;
    private static boolean sysio;

    public Application(String string, String[] stringArray) throws ApplicationException {
        this(string, stringArray, null, "");
    }

    public Application(String string, String[] stringArray, String string2) throws ApplicationException {
        this(string, stringArray, null, string2);
    }

    public Application(String string, String[] stringArray, ApplicationResource applicationResource) throws ApplicationException {
        this(string, stringArray, applicationResource, "");
    }

    public Application(String string, String[] stringArray, ApplicationResource applicationResource, String string2) throws ApplicationException {
        this(string, stringArray, applicationResource, new ClassPathReader(true, string2));
    }

    public Application(String string, String[] stringArray, ApplicationResource applicationResource, ResourceReader resourceReader) throws ApplicationException {
        this.reader = resourceReader;
        try {
            Class clazz = this.loadClass(string);
            this.runMethod = clazz.getMethod("main", new Class[]{stringArray.getClass()});
            this.arguments = stringArray;
            this.tid = new Thread(null, this, string);
            if (applicationResource != null) {
                this.initResource = applicationResource;
                this.add(applicationResource);
            }
            Application.setupSystemIO();
            this.tid.start();
            return;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new ApplicationException(new StringBuffer().append("No main() method in ").append(string).toString());
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new ApplicationException(new StringBuffer().append("Application ").append(string).append(" class not found").toString());
        }
    }

    @Override
    public void run() {
        block4: {
            try {
                this.runMethod.invoke(null, new Object[]{this.arguments});
            }
            catch (Throwable throwable) {
                Throwable throwable2;
                if (throwable instanceof InvocationTargetException) {
                    throwable2 = ((InvocationTargetException)throwable).getTargetException();
                }
                if (throwable2 instanceof ThreadDeath) break block4;
                throwable2.printStackTrace();
                this.exception = throwable2;
                this.exitcode = 1;
            }
        }
        if (this.resources != null && this.resources.size() == 1 && this.resources.elementAt(0) == this.initResource) {
            this.initResource.freeResource();
        }
    }

    public static Application getApplication() {
        Class[] classArray = Application.classStack0();
        int n = 0;
        while (n < classArray.length) {
            ClassLoader classLoader = classArray[n].getClassLoader();
            if (classLoader instanceof Application) {
                return (Application)classLoader;
            }
            ++n;
        }
        return null;
    }

    public void freeAllResources() {
        if (this.resources == null) {
            return;
        }
        Enumeration enumeration = this.resources.elements();
        while (enumeration.hasMoreElements()) {
            ApplicationResource applicationResource = (ApplicationResource)enumeration.nextElement();
            applicationResource.freeResource();
        }
    }

    public static void addResource(ApplicationResource applicationResource) {
        Application application = Application.getApplication();
        if (application != null) {
            application.add(applicationResource);
        }
    }

    public static void removeResource(ApplicationResource applicationResource) {
        Application application = Application.getApplication();
        if (application != null) {
            application.remove(applicationResource);
        }
    }

    private synchronized void add(ApplicationResource applicationResource) {
        if (this.resources == null) {
            this.resources = new Vector();
        }
        this.resources.addElement(applicationResource);
    }

    public synchronized void remove(ApplicationResource applicationResource) {
        if (this.resources != null) {
            this.resources.removeElement(applicationResource);
        }
    }

    private static synchronized void setupSystemIO() {
        if (sysio) {
            return;
        }
        try {
            System.setIn(new 1(System.in));
            System.setOut(new 2(System.out));
            System.setErr(new 3(System.err));
            sysio = true;
            return;
        }
        catch (SecurityException securityException) {
            return;
        }
    }

    public static boolean exit(int n) {
        Application application = Application.getApplication();
        if (application == null) {
            return false;
        }
        application.exitcode = n;
        application.freeAllResources();
        return true;
    }

    public int waitFor() throws InterruptedException {
        this.tid.join();
        return this.exitcode;
    }

    public Throwable exitException() {
        return this.exception;
    }

    public int exitValue() {
        return this.exitcode;
    }

    @Override
    public URL getResource(String string) {
        return ClassLoader.getSystemResource(string);
    }

    @Override
    public InputStream getResourceAsStream(String string) {
        InputStream inputStream = ClassLoader.getSystemResourceAsStream(string);
        if (inputStream != null) {
            return inputStream;
        }
        try {
            inputStream = this.reader.getResourceAsStream(string);
        }
        catch (Exception exception) {
            inputStream = null;
        }
        return inputStream;
    }

    @Override
    public Class loadClass(String string, boolean bl) throws ClassNotFoundException {
        Object object;
        Class clazz = this.findLoadedClass(string);
        if (clazz == null) {
            if (string.startsWith("java.") || string.startsWith("kaffe.")) {
                try {
                    clazz = this.findSystemClass(string);
                }
                catch (ClassNotFoundException classNotFoundException) {
                }
                catch (NoClassDefFoundError noClassDefFoundError) {}
            } else {
                try {
                    object = new StringBuffer().append(string.replace('.', '/')).append(".class").toString();
                    InputStream inputStream = ClassLoader.getSystemResourceAsStream((String)object);
                    byte[] byArray = new byte[inputStream.available()];
                    inputStream.read(byArray);
                    inputStream.close();
                    clazz = this.defineClass(null, byArray, 0, byArray.length);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        if (clazz == null) {
            try {
                object = this.reader.getByteCode(string);
                clazz = this.defineClass(null, (byte[])object, 0, ((byte[])object).length);
            }
            catch (Exception exception) {
                throw new ClassNotFoundException(string);
            }
        }
        if (clazz != null && bl) {
            this.resolveClass(clazz);
        }
        return clazz;
    }

    private native void exit0();

    private static native Class[] classStack0();

    /*
     * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class 1
    extends FilterInputStream {
        @Override
        public void close() {
        }

        public 1(InputStream inputStream) {
            super(inputStream);
        }
    }

    /*
     * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class 2
    extends PrintStream {
        @Override
        public void close() {
            this.flush();
        }

        public 2(OutputStream outputStream) {
            super(outputStream);
        }
    }

    /*
     * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class 3
    extends PrintStream {
        @Override
        public void close() {
            this.flush();
        }

        public 3(OutputStream outputStream) {
            super(outputStream);
        }
    }
}

