/*
 * Decompiled with CFR 0.152.
 */
package kaffe.lang;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

/*
 * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SystemClassLoader
extends ClassLoader {
    private static final ClassLoader singleton = new SystemClassLoader();

    private SystemClassLoader() {
        super(null);
    }

    private static String componentType(String string) throws ClassNotFoundException {
        int n = string.lastIndexOf(91) + 1;
        if (string.charAt(n) == 'L') {
            if (string.endsWith(";")) {
                return string.substring(n + 1, string.length() - 1);
            }
            throw new ClassNotFoundException(string);
        }
        if (string.endsWith(";")) {
            throw new ClassNotFoundException(string);
        }
        if (string.length() - n > 1) {
            return string.substring(n);
        }
        return string.substring(n - 1);
    }

    public static ClassLoader getClassLoader() {
        return singleton;
    }

    @Override
    public Enumeration findResources(String string) throws IOException {
        String string2 = System.getProperties().getProperty("file.separator");
        String string3 = System.getProperties().getProperty("path.separator");
        String string4 = System.getProperties().getProperty("java.class.path");
        StringTokenizer stringTokenizer = new StringTokenizer(string4, string3);
        Vector vector = new Vector();
        if (string.startsWith("/")) {
            string = string.substring(1);
        }
        while (stringTokenizer.hasMoreTokens()) {
            Object var10_10;
            Object object2;
            File file = new File(stringTokenizer.nextToken());
            if (!file.exists()) continue;
            if (file.isDirectory()) {
                if (!(file = new File(file, string)).isFile()) continue;
                try {
                    vector.addElement(new URL("file", "", file.getCanonicalPath().replace(File.separatorChar, '/')));
                }
                catch (MalformedURLException malformedURLException) {}
                continue;
            }
            if (!file.isFile()) continue;
            ZipFile zipFile = null;
            try {
                try {
                    zipFile = new ZipFile(file);
                    object2 = zipFile.getEntry(string);
                    if (object2 != null && !((ZipEntry)object2).isDirectory()) {
                        URL uRL = new URL(new StringBuffer().append("jar:file:").append(file.getCanonicalPath().replace(File.separatorChar, '/')).append("!/").append(((ZipEntry)object2).getName()).toString());
                        vector.addElement(uRL);
                    }
                }
                catch (IOException iOException) {
                }
                var10_10 = null;
                if (zipFile == null) continue;
            }
            catch (Throwable throwable) {
                var10_10 = null;
                if (zipFile != null) {
                    try {
                        zipFile.close();
                    }
                    catch (IOException object2) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
            try {
                zipFile.close();
            }
            catch (IOException object2) {}
        }
        return vector.elements();
    }

    @Override
    protected Class findClass(String string) throws ClassNotFoundException {
        if (string.endsWith("[V")) {
            throw new ClassNotFoundException(string);
        }
        if (string.startsWith("[") && string.length() >= 3) {
            try {
                String string2 = SystemClassLoader.componentType(string);
                this.loadClass(string2);
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                throw new ClassNotFoundException(noClassDefFoundError.getMessage());
            }
        }
        return this.findClass0(string);
    }

    private native Class findClass0(String var1) throws ClassNotFoundException;
}

